/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base;

import java.util.Objects;

public class Ratio {
    private final int numerator;
    private final int denominator;

    public static Ratio combine(Ratio left, Ratio right) {
        return Ratio.of(left.numerator + right.numerator, left.denominator + right.denominator);
    }

    public static Ratio of(int numerator, int denominator) {
        if (numerator < 0) {
            throw new IllegalArgumentException("Numerator must be non-negative");
        }
        if (denominator <= 0) {
            throw new IllegalArgumentException("Denominator must be positive");
        }
        if (numerator > denominator) {
            throw new IllegalArgumentException("Numerator " + numerator + " must be less than or equal to denominator " + denominator);
        }
        return new Ratio(numerator, denominator);
    }

    private Ratio(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public boolean isPositive() {
        return this.numerator > 0;
    }

    public boolean isZero() {
        return this.numerator == 0;
    }

    public int numerator() {
        return this.numerator;
    }

    public int denominator() {
        return this.denominator;
    }

    public float frequency() {
        return (float)this.numerator / (float)this.denominator;
    }

    public static int compare(Ratio left, Ratio right) {
        return Float.compare(left.frequency(), right.frequency());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return this.numerator == ratio.numerator && this.denominator == ratio.denominator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public String toString() {
        return "Ratio{numerator=" + this.numerator + ", denominator=" + this.denominator + "}";
    }
}

