/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import org.monarchinitiative.phenol.annotations.base.temporal.AgeGestational;
import org.monarchinitiative.phenol.annotations.base.temporal.AgePostnatal;

public interface Age {
    public static final double DAYS_IN_JULIAN_YEAR = 365.25;
    public static final double DAYS_IN_MONTH = 30.4375;
    public static final int MAX_DAYS = 730500;

    public static Age lastMenstrualPeriod() {
        return AgeGestational.LMP;
    }

    public static Age birth() {
        return AgePostnatal.BIRTH;
    }

    public static Age gestational(int weeks, int days) {
        return Age.of(days += weeks * 7, true);
    }

    public static Age postnatal(int years, int months, int days) {
        return Age.postnatal(days += Math.toIntExact(Math.round(Age.convertYearsAndMonthsToDays(years, months))));
    }

    public static double convertYearsAndMonthsToDays(int years, int months) {
        return (double)years * 365.25 + (double)months * 30.4375;
    }

    public static Age postnatal(int days) {
        return Age.of(days, false);
    }

    public static Age of(int days, boolean gestational) {
        if (days == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Integer MAX_VALUE is reserved for open end age");
        }
        if (days < 0) {
            throw new IllegalArgumentException("Days must not be negative, got '" + days + "' days!");
        }
        if (days > 730500) {
            throw new ArithmeticException("Normalized number of days must not be greater than '730500'. Got '" + days + "'");
        }
        return gestational ? AgeGestational.of(days) : AgePostnatal.of(days);
    }

    public static Age openStart() {
        return AgeGestational.START;
    }

    public static Age openEnd() {
        return AgePostnatal.END;
    }

    public int days();

    public boolean isGestational();

    public boolean isOpen();

    default public boolean isClosed() {
        return !this.isOpen();
    }

    default public boolean isZero() {
        return this.days() == 0;
    }

    default public boolean isPositive() {
        return this.days() > 0;
    }

    default public Age plus(Age other) {
        int days = this.days() + other.days();
        return Age.of(days, this.isGestational());
    }

    public static Age max(Age a, Age b) {
        int compare = Age.compare(a, b);
        return compare >= 0 ? a : b;
    }

    public static Age min(Age a, Age b) {
        int compare = Age.compare(a, b);
        return compare <= 0 ? a : b;
    }

    public static int compare(Age x, Age y) {
        if (x.isGestational() ^ y.isGestational()) {
            return x.isGestational() ? -1 : 1;
        }
        return Integer.compare(x.days(), y.days());
    }
}

