/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.AgeOpen;

class AgeGestational
implements Age {
    public static final Age START = new AgeOpen(Integer.MIN_VALUE, true);
    static final Age LMP = new AgeGestational(0);
    private final int days;

    static Age of(int days) {
        return days == 0 ? LMP : new AgeGestational(days);
    }

    private AgeGestational(int days) {
        this.days = days;
    }

    @Override
    public int days() {
        return this.days;
    }

    @Override
    public boolean isGestational() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgeGestational ageDays = (AgeGestational)o;
        return this.days == ageDays.days;
    }

    public int hashCode() {
        return Objects.hash(this.days, true);
    }

    public String toString() {
        return "AgeGestational{days=" + this.days + "}";
    }
}

