/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.AgeOpen;

class AgePostnatal
implements Age {
    static final AgeOpen END = new AgeOpen(Integer.MAX_VALUE, false);
    static final AgePostnatal BIRTH = new AgePostnatal(0);
    private final int days;

    static Age of(int days) {
        return days == 0 ? BIRTH : new AgePostnatal(days);
    }

    private AgePostnatal(int days) {
        if (days > 730500) {
            throw new ArithmeticException(String.format("Number of days %d must not be greater than %d", days, 730500));
        }
        this.days = days;
    }

    @Override
    public int days() {
        return this.days;
    }

    @Override
    public boolean isGestational() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgePostnatal that = (AgePostnatal)o;
        return this.days == that.days;
    }

    public int hashCode() {
        return Objects.hash(this.days, true);
    }

    public String toString() {
        return "AgePostnatal{days=" + this.days + "}";
    }
}

