/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalIntervalDefault;

public interface TemporalInterval {
    public static TemporalInterval birth() {
        return TemporalIntervalDefault.of(Age.birth(), Age.birth());
    }

    public static TemporalInterval of(Age start, Age end) {
        int result = Age.compare(start, end);
        if (result > 0) {
            throw new IllegalArgumentException(String.format("Start (%d days) must not be after end (%d days)", start.days(), end.days()));
        }
        return TemporalIntervalDefault.of(start, end);
    }

    public static TemporalInterval openStart(Age end) {
        return TemporalIntervalDefault.of(Age.openStart(), end);
    }

    public static TemporalInterval openEnd(Age start) {
        return TemporalIntervalDefault.of(start, Age.openEnd());
    }

    public static TemporalInterval open() {
        return TemporalInterval.of(Age.openStart(), Age.openEnd());
    }

    public Age start();

    public Age end();

    default public boolean isStartOpen() {
        return this.start().isOpen();
    }

    default public boolean isStartClosed() {
        return !this.isStartOpen();
    }

    default public boolean isEndOpen() {
        return this.end().isOpen();
    }

    default public boolean isEndClosed() {
        return !this.isEndOpen();
    }

    default public boolean isFullyOpen() {
        return this.isStartOpen() && this.isEndOpen();
    }

    default public boolean isFullyClosed() {
        return this.isStartClosed() && this.isEndClosed();
    }

    default public TemporalInterval length() {
        if (this.isFullyClosed()) {
            return TemporalInterval.of(Age.birth(), Age.postnatal(this.end().days() - this.start().days()));
        }
        return TemporalInterval.open();
    }

    default public boolean isEmpty() {
        TemporalInterval length = this.length();
        return length.end().isZero();
    }

    default public TemporalInterval intersection(TemporalInterval other) {
        Age end;
        Age start = Age.max(this.start(), other.start());
        int compare = Age.compare(start, end = Age.min(this.end(), other.end()));
        if (compare > 0) {
            return TemporalInterval.birth();
        }
        return TemporalInterval.of(start, end);
    }

    default public boolean overlapsWith(TemporalInterval other) {
        return !this.intersection(other).isEmpty();
    }

    default public boolean contains(Age age) {
        int start = Age.compare(this.start(), age);
        int end = Age.compare(this.end(), age);
        return start <= 0 && 0 < end;
    }

    public static int compare(TemporalInterval x, TemporalInterval y) {
        int result = Age.compare(x.start(), y.start());
        if (result != 0) {
            return result;
        }
        return Age.compare(x.end(), y.end());
    }
}

