/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.go;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.formats.go.GoQualifier;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GoGaf22Annotation
implements TermAnnotation {
    private final TermId dbObjectTermId;
    private final String dbObjectSymbol;
    private final GoQualifier qualifier;
    private final boolean negated;
    private final TermId goId;
    private final String dbReference;
    private final String evidenceCode;
    private final String with;
    private final String aspect;
    private final String dbObjectName;
    private final String dbObjectSynonym;
    private final String dbObjectType;
    private final List<String> taxons;
    private final Date date;
    private final String assignedBy;
    private final String annotationExtension;
    private final String geneProductFormId;

    private GoGaf22Annotation(String[] arr) throws PhenolException {
        this.dbObjectTermId = arr[1].contains(":") ? TermId.of((String)arr[1]) : TermId.of((String)arr[0], (String)arr[1]);
        this.dbObjectSymbol = arr[2];
        String qualifierString = arr[3];
        if (qualifierString.startsWith("NOT|")) {
            this.negated = true;
            this.qualifier = GoQualifier.fromString(qualifierString.substring(4));
        } else {
            this.negated = false;
            this.qualifier = GoQualifier.fromString(qualifierString);
        }
        this.goId = TermId.of((String)arr[4]);
        this.dbReference = arr[5];
        this.evidenceCode = arr[6];
        this.with = arr[7];
        this.aspect = arr[8];
        this.dbObjectName = arr[9];
        this.dbObjectSynonym = arr[10];
        this.dbObjectType = arr[11];
        this.taxons = Arrays.asList(arr[12].split("\\|"));
        String dateStr = arr[13];
        this.assignedBy = arr[14];
        this.annotationExtension = arr.length < 16 ? null : arr[15];
        this.geneProductFormId = arr.length < 17 ? null : arr[16];
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            this.date = format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new PhenolException("There was a problem parsing the date value " + dateStr, (Throwable)e);
        }
    }

    public static GoGaf22Annotation parseAnnotation(String line) throws PhenolException {
        CharSequence[] arr = line.split("\t");
        if (arr.length < 15 || arr.length > 17) {
            throw new PhenolException("GAF line had " + arr.length + " columns, but expected between 15 and 17 entries. \n Line was:" + String.join((CharSequence)"\t", arr));
        }
        return new GoGaf22Annotation((String[])arr);
    }

    public String getDb() {
        return this.dbObjectTermId.getPrefix();
    }

    public String getDbObjectId() {
        return this.dbObjectTermId.getId();
    }

    public TermId getDbObjectTermId() {
        return this.dbObjectTermId;
    }

    public String getDbObjectSymbol() {
        return this.dbObjectSymbol;
    }

    public GoQualifier getQualifier() {
        return this.qualifier;
    }

    public TermId getGoId() {
        return this.goId;
    }

    public String getDbReference() {
        return this.dbReference;
    }

    public Optional<String> getEvidenceCode() {
        return Optional.ofNullable(this.evidenceCode);
    }

    public String getWith() {
        return this.with;
    }

    public String getAspect() {
        return this.aspect;
    }

    public String getDbObjectName() {
        return this.dbObjectName;
    }

    public String getDbObjectSynonym() {
        return this.dbObjectSynonym;
    }

    public String getDbObjectType() {
        return this.dbObjectType;
    }

    public List<String> getTaxons() {
        return this.taxons;
    }

    public Date getDate() {
        return this.date;
    }

    public String getAssignedBy() {
        return this.assignedBy;
    }

    public String getAnnotationExtension() {
        return this.annotationExtension;
    }

    public String getGeneProductFormId() {
        return this.geneProductFormId;
    }

    public TermId id() {
        return this.goId;
    }

    public TermId getItemId() {
        return this.dbObjectTermId;
    }

    public int compareTo(TermAnnotation o) {
        if (!(o instanceof GoGaf22Annotation)) {
            throw new PhenolRuntimeException("Can only compare GoGaf21Annotation with objects of same type");
        }
        GoGaf22Annotation that = (GoGaf22Annotation)o;
        int result = this.annotationExtension.compareTo(that.annotationExtension);
        if (result != 0) {
            return result;
        }
        result = this.aspect.compareTo(that.aspect);
        if (result != 0) {
            return result;
        }
        result = this.assignedBy.compareTo(that.assignedBy);
        if (result != 0) {
            return result;
        }
        result = this.date.compareTo(that.date);
        if (result != 0) {
            return result;
        }
        result = this.dbObjectTermId.compareTo(that.dbObjectTermId);
        if (result != 0) {
            return result;
        }
        result = this.dbObjectName.compareTo(that.dbObjectName);
        if (result != 0) {
            return result;
        }
        result = this.dbObjectSymbol.compareTo(that.dbObjectSymbol);
        if (result != 0) {
            return result;
        }
        result = this.dbObjectSynonym.compareTo(that.dbObjectSynonym);
        if (result != 0) {
            return result;
        }
        result = this.dbObjectType.compareTo(that.dbObjectType);
        if (result != 0) {
            return result;
        }
        result = this.dbReference.compareTo(that.dbReference);
        if (result != 0) {
            return result;
        }
        result = this.evidenceCode.compareTo(that.evidenceCode);
        if (result != 0) {
            return result;
        }
        result = this.geneProductFormId.compareTo(that.geneProductFormId);
        if (result != 0) {
            return result;
        }
        result = this.goId.compareTo(that.goId);
        if (result != 0) {
            return result;
        }
        result = this.qualifier.compareTo(that.qualifier);
        if (result != 0) {
            return result;
        }
        for (int i = 0; i < this.taxons.size(); ++i) {
            String thatTaxon;
            String thisTaxon = this.taxons.get(i);
            result = thisTaxon.compareTo(thatTaxon = that.taxons.get(i));
            if (result == 0) continue;
            return result;
        }
        return this.with.compareTo(that.with);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationExtension == null ? 0 : this.annotationExtension.hashCode());
        result = 31 * result + (this.aspect == null ? 0 : this.aspect.hashCode());
        result = 31 * result + (this.assignedBy == null ? 0 : this.assignedBy.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.dbObjectTermId == null ? 0 : this.dbObjectTermId.hashCode());
        result = 31 * result + (this.dbObjectName == null ? 0 : this.dbObjectName.hashCode());
        result = 31 * result + (this.dbObjectSymbol == null ? 0 : this.dbObjectSymbol.hashCode());
        result = 31 * result + (this.dbObjectSynonym == null ? 0 : this.dbObjectSynonym.hashCode());
        result = 31 * result + (this.dbObjectType == null ? 0 : this.dbObjectType.hashCode());
        result = 31 * result + (this.dbReference == null ? 0 : this.dbReference.hashCode());
        result = 31 * result + (this.evidenceCode == null ? 0 : this.evidenceCode.hashCode());
        result = 31 * result + (this.geneProductFormId == null ? 0 : this.geneProductFormId.hashCode());
        result = 31 * result + (this.goId == null ? 0 : this.goId.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.taxons == null ? 0 : this.taxons.hashCode());
        result = 31 * result + (this.with == null ? 0 : this.with.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GoGaf22Annotation)) {
            return false;
        }
        GoGaf22Annotation other = (GoGaf22Annotation)obj;
        if (this.annotationExtension == null ? other.annotationExtension != null : !this.annotationExtension.equals(other.annotationExtension)) {
            return false;
        }
        if (this.aspect == null ? other.aspect != null : !this.aspect.equals(other.aspect)) {
            return false;
        }
        if (this.assignedBy == null ? other.assignedBy != null : !this.assignedBy.equals(other.assignedBy)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.dbObjectTermId == null ? other.dbObjectTermId != null : !this.dbObjectTermId.equals((Object)other.dbObjectTermId)) {
            return false;
        }
        if (this.dbObjectName == null ? other.dbObjectName != null : !this.dbObjectName.equals(other.dbObjectName)) {
            return false;
        }
        if (this.dbObjectSymbol == null ? other.dbObjectSymbol != null : !this.dbObjectSymbol.equals(other.dbObjectSymbol)) {
            return false;
        }
        if (this.dbObjectSynonym == null ? other.dbObjectSynonym != null : !this.dbObjectSynonym.equals(other.dbObjectSynonym)) {
            return false;
        }
        if (this.dbObjectType == null ? other.dbObjectType != null : !this.dbObjectType.equals(other.dbObjectType)) {
            return false;
        }
        if (this.dbReference == null ? other.dbReference != null : !this.dbReference.equals(other.dbReference)) {
            return false;
        }
        if (this.evidenceCode == null ? other.evidenceCode != null : !this.evidenceCode.equals(other.evidenceCode)) {
            return false;
        }
        if (this.geneProductFormId == null ? other.geneProductFormId != null : !this.geneProductFormId.equals(other.geneProductFormId)) {
            return false;
        }
        if (this.goId == null ? other.goId != null : !this.goId.equals((Object)other.goId)) {
            return false;
        }
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals((Object)other.qualifier)) {
            return false;
        }
        if (this.taxons == null ? other.taxons != null : !this.taxons.equals(other.taxons)) {
            return false;
        }
        if (this.with == null) {
            return other.with == null;
        }
        return this.with.equals(other.with);
    }

    public String toString() {
        return "GoGaf22Annotation [db=" + this.dbObjectTermId.getPrefix() + ", dbObjectId=" + this.dbObjectTermId.getId() + ", dbObjectSymbol=" + this.dbObjectSymbol + ", qualifier=" + this.qualifier + ", goId=" + this.goId + ", dbReference=" + this.dbReference + ", evidenceCode=" + this.evidenceCode + ", with=" + this.with + ", aspect=" + this.aspect + ", dbObjectName=" + this.dbObjectName + ", dbObjectSynonym=" + this.dbObjectSynonym + ", dbObjectType=" + this.dbObjectType + ", taxons=" + this.taxons + ", date=" + this.date + ", assignedBy=" + this.assignedBy + ", annotationExtension=" + this.annotationExtension + ", geneProductFormId=" + this.geneProductFormId + "]";
    }
}

