/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

@Deprecated(forRemoval=true, since="2.0.0-RC2")
public class HpoAnnotation
implements Identified {
    private final TermId termId;
    private final AnnotationFrequency annotationFrequency;
    private final HpoOnset onset;
    private final List<TermId> modifiers;
    private final List<String> citations;
    private final EvidenceCode evidence;
    private final Sex sex;

    public static HpoAnnotation of(TermId termId, AnnotationFrequency annotationFrequency, HpoOnset onset, List<TermId> modifiers, List<String> cites, EvidenceCode evidenceCode, Sex sex) {
        return new HpoAnnotation(termId, annotationFrequency, onset, modifiers, cites, evidenceCode, sex);
    }

    private HpoAnnotation(TermId termId, AnnotationFrequency annotationFrequency, HpoOnset onset, List<TermId> modifiers, List<String> cites, EvidenceCode evidenceCode, Sex sex) {
        this.termId = Objects.requireNonNull(termId, "Term ID must not be null");
        this.annotationFrequency = Objects.requireNonNull(annotationFrequency, "Annotation frequency must not be null");
        this.onset = onset;
        this.modifiers = Objects.requireNonNull(modifiers, "Modifiers must not be null");
        this.citations = Objects.requireNonNull(cites, "Citations must not be null");
        this.evidence = Objects.requireNonNull(evidenceCode, "Evidence code must not be null");
        this.sex = sex;
    }

    public TermId id() {
        return this.termId;
    }

    public AnnotationFrequency annotationFrequency() {
        return this.annotationFrequency;
    }

    public Optional<HpoOnset> onset() {
        return Optional.ofNullable(this.onset);
    }

    public List<TermId> modifiers() {
        return this.modifiers;
    }

    public List<String> citations() {
        return this.citations;
    }

    public EvidenceCode evidence() {
        return this.evidence;
    }

    public boolean isPCS() {
        return this.evidence == EvidenceCode.PCS;
    }

    public boolean isIEA() {
        return this.evidence == EvidenceCode.IEA;
    }

    public boolean isTAS() {
        return this.evidence == EvidenceCode.TAS;
    }

    public Sex sex() {
        return this.sex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.termId, this.annotationFrequency, this.onset, this.modifiers, this.citations, this.evidence, this.sex});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoAnnotation that = (HpoAnnotation)o;
        return Objects.equals(this.termId, that.termId) && Objects.equals(this.annotationFrequency, that.annotationFrequency) && this.onset == that.onset && Objects.equals(this.modifiers, that.modifiers) && Objects.equals(this.citations, that.citations) && this.evidence == that.evidence && this.sex == that.sex;
    }

    public String toString() {
        return "HpoAnnotation{termId=" + this.termId + ", annotationFrequency=" + this.annotationFrequency + ", onset=" + this.onset + ", modifiers=" + this.modifiers + ", citations=" + this.citations + ", evidence=" + this.evidence + ", sex=" + this.sex + "}";
    }
}

