/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseDefault;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDisease
extends Identified {
    public static HpoDisease of(TermId diseaseId, String name, TemporalInterval globalOnset, List<HpoDiseaseAnnotation> phenotypicAbnormalities, List<TermId> modesOfInheritance) {
        return new HpoDiseaseDefault(diseaseId, name, globalOnset, phenotypicAbnormalities, modesOfInheritance);
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId diseaseDatabaseTermId() {
        return this.id();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId getDiseaseDatabaseTermId() {
        return this.id();
    }

    public String diseaseName();

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getName() {
        return this.diseaseName();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getDiseaseName() {
        return this.diseaseName();
    }

    public Optional<TemporalInterval> diseaseOnset();

    public List<TermId> modesOfInheritance();

    @Deprecated(forRemoval=true, since="2.0.0-RC2")
    default public List<TermId> getModesOfInheritance() {
        return this.modesOfInheritance();
    }

    public Iterable<HpoDiseaseAnnotation> annotations();

    public int annotationCount();

    default public Stream<HpoDiseaseAnnotation> annotationStream() {
        return StreamSupport.stream(this.annotations().spliterator(), false);
    }

    @Deprecated(forRemoval=true)
    default public Iterator<HpoDiseaseAnnotation> phenotypicAbnormalities() {
        return this.annotations().iterator();
    }

    @Deprecated(forRemoval=true)
    default public int phenotypicAbnormalitiesCount() {
        return this.annotationCount();
    }

    @Deprecated(forRemoval=true)
    default public Stream<HpoDiseaseAnnotation> phenotypicAbnormalitiesStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.phenotypicAbnormalities(), (long)this.phenotypicAbnormalitiesCount(), 0), false);
    }

    @Deprecated(forRemoval=true, since="2.0.0-RC2")
    default public List<HpoAnnotation> getPhenotypicAbnormalities() {
        throw new PhenolRuntimeException("The 'getPhenotypicAbnormalities()` method was deprecated. Use `phenotypicAbnormalities()` instead!");
    }

    default public Stream<HpoDiseaseAnnotation> absentAnnotationsStream() {
        return this.phenotypicAbnormalitiesStream().filter(a -> a.ratio().isZero());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> negativeAnnotations() {
        return this.absentAnnotationsStream().map(Identified::id).collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getNegativeAnnotations() {
        return this.negativeAnnotations();
    }

    default public Optional<HpoDiseaseAnnotation> getAnnotation(TermId termId) {
        return this.phenotypicAbnormalitiesStream().filter(diseaseAnnotation -> diseaseAnnotation.id().equals((Object)termId)).findAny();
    }

    default public Optional<Ratio> getFrequencyOfTermInDisease(TermId termId) {
        return this.phenotypicAbnormalitiesStream().filter(diseaseAnnotation -> diseaseAnnotation.id().equals((Object)termId)).findFirst().map(HpoDiseaseAnnotation::ratio);
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getPhenotypicAbnormalityTermIdList() {
        return this.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public Stream<TermId> getPhenotypicAbnormalityTermIds() {
        return this.annotationTermIds();
    }

    default public Stream<TermId> annotationTermIds() {
        return this.annotationStream().map(Identified::id);
    }

    default public List<TermId> annotationTermIdList() {
        return this.annotationTermIds().collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public long getNumberOfPhenotypeAnnotations() {
        return this.annotationCount();
    }

    default public boolean isAnnotatedTo(TermId termId, Ontology hpo) {
        List directAnnotations = this.phenotypicAbnormalitiesStream().filter(HpoDiseaseAnnotation::isPresent).map(Identified::id).collect(Collectors.toList());
        Set ancestors = hpo.getAllAncestorTermIds(directAnnotations, true);
        return ancestors.contains(termId);
    }

    default public boolean isDirectlyAnnotatedTo(TermId termId) {
        return this.phenotypicAbnormalitiesStream().anyMatch(annotation -> annotation.id().equals((Object)termId));
    }

    default public boolean isDirectlyAnnotatedToAnyOf(Set<TermId> termIds) {
        return this.phenotypicAbnormalitiesStream().anyMatch(tiwm -> termIds.contains(tiwm.id()));
    }
}

