/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDiseaseAnnotation
extends Identified,
Comparable<HpoDiseaseAnnotation> {
    public static final Comparator<HpoDiseaseAnnotation> COMPARATOR = Comparator.comparing(Identified::id);

    public static HpoDiseaseAnnotation of(TermId termId, Collection<HpoDiseaseAnnotationMetadata> metadata) {
        float frequency = metadata.stream().map(meta -> meta.frequency().flatMap(AnnotationFrequency::ratio)).flatMap(Optional::stream).reduce(Ratio::combine).map(Ratio::frequency).orElse(Float.valueOf(0.0f)).floatValue();
        if ((double)frequency > 1.0) {
            throw new IllegalArgumentException("Total frequency cannot be greater than 1: " + frequency);
        }
        return HpoDiseaseAnnotationDefault.of(termId, metadata);
    }

    @Deprecated(since="2.0.0-RC1", forRemoval=true)
    default public TermId termId() {
        return this.id();
    }

    public Stream<HpoDiseaseAnnotationMetadata> metadata();

    public Ratio ratio();

    default public float frequency() {
        return this.ratio().frequency();
    }

    default public boolean isAbsent() {
        return this.ratio().isZero();
    }

    default public boolean isPresent() {
        return !this.isAbsent();
    }

    public List<TemporalInterval> observationIntervals();

    public Optional<Ratio> observedInInterval(TemporalInterval var1);

    default public Optional<Age> earliestOnset() {
        return this.metadata().filter(HpoDiseaseAnnotationMetadata::isPresent).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::start).min(Age::compare);
    }

    default public Optional<Age> latestOnset() {
        return this.metadata().filter(HpoDiseaseAnnotationMetadata::isPresent).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::start).max(Age::compare);
    }

    default public Optional<Age> earliestResolution() {
        return this.metadata().filter(HpoDiseaseAnnotationMetadata::isPresent).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::end).min(Age::compare);
    }

    default public Optional<Age> latestResolution() {
        return this.metadata().filter(HpoDiseaseAnnotationMetadata::isPresent).map(HpoDiseaseAnnotationMetadata::observationInterval).flatMap(Optional::stream).map(TemporalInterval::end).max(Age::compare);
    }

    default public List<AnnotationReference> references() {
        return this.metadata().map(HpoDiseaseAnnotationMetadata::reference).collect(Collectors.toList());
    }

    @Override
    default public int compareTo(HpoDiseaseAnnotation other) {
        return COMPARATOR.compare(this, other);
    }
}

