/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseAnnotationDefault
implements HpoDiseaseAnnotation {
    private final TermId termId;
    private final Collection<HpoDiseaseAnnotationMetadata> metadata;
    private final Ratio ratio;
    private final List<TemporalInterval> observationIntervals;

    static HpoDiseaseAnnotationDefault of(TermId termId, Collection<HpoDiseaseAnnotationMetadata> metadata) {
        int numerator = 0;
        int denominator = 0;
        LinkedList<TemporalInterval> observationIntervals = new LinkedList<TemporalInterval>();
        for (HpoDiseaseAnnotationMetadata datum : metadata) {
            Optional<TemporalInterval> interval;
            Optional ratio = datum.frequency().flatMap(AnnotationFrequency::ratio);
            if (ratio.isPresent()) {
                Ratio r = (Ratio)ratio.get();
                numerator += r.numerator();
                denominator += r.denominator();
            }
            if (!(interval = datum.observationInterval()).isPresent()) continue;
            TemporalInterval current = interval.get();
            boolean overlapFound = false;
            for (int j = 0; j < observationIntervals.size(); ++j) {
                TemporalInterval other = (TemporalInterval)observationIntervals.get(j);
                if (!current.overlapsWith(other)) continue;
                observationIntervals.set(j, TemporalInterval.of(Age.min(current.start(), other.start()), Age.max(current.end(), other.end())));
                overlapFound = true;
                break;
            }
            if (overlapFound) continue;
            observationIntervals.add(current);
        }
        Ratio ratio = numerator == 0 && denominator == 0 ? null : Ratio.of(numerator, denominator);
        List<TemporalInterval> intervals = observationIntervals.stream().sorted(TemporalInterval::compare).collect(Collectors.toUnmodifiableList());
        return new HpoDiseaseAnnotationDefault(termId, metadata, ratio, intervals);
    }

    private HpoDiseaseAnnotationDefault(TermId termId, Collection<HpoDiseaseAnnotationMetadata> metadata, Ratio ratio, List<TemporalInterval> observationIntervals) {
        this.termId = Objects.requireNonNull(termId, "Term ID must not be null");
        this.metadata = metadata;
        this.ratio = Objects.requireNonNull(ratio, "Ratio must not be null!");
        this.observationIntervals = observationIntervals;
    }

    public TermId id() {
        return this.termId;
    }

    @Override
    public Stream<HpoDiseaseAnnotationMetadata> metadata() {
        return this.metadata.stream();
    }

    @Override
    public Ratio ratio() {
        return this.ratio;
    }

    @Override
    public List<TemporalInterval> observationIntervals() {
        return this.observationIntervals;
    }

    @Override
    public Optional<Ratio> observedInInterval(TemporalInterval target) {
        return this.metadata.stream().filter(meta -> meta.observationInterval().map(interval -> interval.overlapsWith(target)).orElse(false)).map(meta -> meta.frequency().flatMap(AnnotationFrequency::ratio)).flatMap(Optional::stream).reduce(Ratio::combine);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoDiseaseAnnotationDefault that = (HpoDiseaseAnnotationDefault)o;
        return Objects.equals(this.termId, that.termId) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.termId, this.metadata);
    }

    public String toString() {
        return "HpoDiseaseAnnotationDefault{termId=" + this.termId + ", metadata=" + this.metadata + "}";
    }
}

