/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadataDefault;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDiseaseAnnotationMetadata {
    public static HpoDiseaseAnnotationMetadata of(AnnotationReference reference, TemporalInterval temporalInterval, AnnotationFrequency frequency, Collection<TermId> modifiers, Sex sex) {
        return new HpoDiseaseAnnotationMetadataDefault(reference, temporalInterval, frequency, modifiers, sex);
    }

    public AnnotationReference reference();

    public Optional<TemporalInterval> observationInterval();

    public Optional<AnnotationFrequency> frequency();

    default public boolean isPresent() {
        return !this.isAbsent();
    }

    default public boolean isAbsent() {
        return this.frequency().flatMap(AnnotationFrequency::ratio).map(Ratio::isZero).orElse(false);
    }

    public Collection<TermId> modifiers();

    public Optional<Sex> sex();

    default public Optional<Age> start() {
        return this.observationInterval().map(TemporalInterval::start);
    }

    default public Optional<Age> end() {
        return this.observationInterval().map(TemporalInterval::end);
    }
}

