/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseAnnotationMetadataDefault
implements HpoDiseaseAnnotationMetadata {
    private final AnnotationReference reference;
    private final TemporalInterval temporalInterval;
    private final AnnotationFrequency frequency;
    private final Collection<TermId> modifiers;
    private final Sex sex;

    HpoDiseaseAnnotationMetadataDefault(AnnotationReference reference, TemporalInterval temporalInterval, AnnotationFrequency frequency, Collection<TermId> modifiers, Sex sex) {
        this.reference = Objects.requireNonNull(reference, "Reference must not be null");
        this.temporalInterval = temporalInterval;
        this.frequency = frequency;
        this.modifiers = Objects.requireNonNull(modifiers, "Modifiers collection must not be null");
        this.sex = sex;
    }

    @Override
    public AnnotationReference reference() {
        return this.reference;
    }

    @Override
    public Optional<TemporalInterval> observationInterval() {
        return Optional.ofNullable(this.temporalInterval);
    }

    @Override
    public Optional<AnnotationFrequency> frequency() {
        return Optional.ofNullable(this.frequency);
    }

    @Override
    public Collection<TermId> modifiers() {
        return this.modifiers;
    }

    @Override
    public Optional<Sex> sex() {
        return Optional.ofNullable(this.sex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoDiseaseAnnotationMetadataDefault that = (HpoDiseaseAnnotationMetadataDefault)o;
        return Objects.equals(this.reference, that.reference) && Objects.equals(this.temporalInterval, that.temporalInterval) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.modifiers, that.modifiers) && Objects.equals((Object)this.sex, (Object)that.sex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reference, this.temporalInterval, this.frequency, this.modifiers, this.sex});
    }

    public String toString() {
        return "HpoDiseaseAnnotationMetadataDefault{reference=" + this.reference + ", temporalInterval=" + this.temporalInterval + ", frequency=" + this.frequency + ", modifiers=" + this.modifiers + ", sex=" + this.sex + "}";
    }
}

