/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseasesDefault
implements HpoDiseases {
    private final List<HpoDisease> hpoDiseases;
    private volatile Map<TermId, HpoDisease> diseaseById;

    HpoDiseasesDefault(List<HpoDisease> hpoDiseases) {
        this.hpoDiseases = Objects.requireNonNull(hpoDiseases, "HPO diseases must not be null");
    }

    @Override
    public Iterator<HpoDisease> iterator() {
        return this.hpoDiseases.iterator();
    }

    @Override
    public Optional<HpoDisease> diseaseById(TermId diseaseId) {
        return Optional.ofNullable(this.diseaseById().get(diseaseId));
    }

    @Override
    public int size() {
        return this.hpoDiseases.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TermId, HpoDisease> diseaseById() {
        if (this.diseaseById == null) {
            HpoDiseasesDefault hpoDiseasesDefault = this;
            synchronized (hpoDiseasesDefault) {
                if (this.diseaseById == null) {
                    this.diseaseById = this.hpoDiseases.stream().collect(Collectors.toUnmodifiableMap(Identified::id, Function.identity()));
                }
            }
        }
        return this.diseaseById;
    }

    @Override
    public Set<TermId> diseaseIds() {
        return this.diseaseById().keySet();
    }
}

