/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo.category;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.annotations.formats.hpo.category.HpoCategory;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpoCategoryMap {
    Logger LOGGER = LoggerFactory.getLogger(HpoCategoryMap.class);
    private final TermId[] termIdList = new TermId[]{INHERITANCE_ID, ABNORMAL_CELLULAR_ID, BLOOD_ID, CONNECTIVE_TISSUE_ID, HEAD_AND_NECK_ID, LIMBS_ID, METABOLISM_ID, PRENATAL_ID, BREAST_ID, CARDIOVASCULAR_ID, DIGESTIVE_ID, CLINICAL_COURSE_ID, EAR_ID, ENDOCRINE_ID, EYE_ID, GENITOURINARY_ID, IMMUNOLOGY_ID, INTEGUMENT_ID, MUSCLE_ID, NERVOUS_SYSTEM_ID, RESPIRATORY_ID, SKELETAL_ID, THORACIC_CAVITY_ID, VOICE_ID, GROWTH_ID, CONSTITUTIONAL_ID, NEOPLASM_ID};
    private final Map<TermId, HpoCategory> categorymap;
    private static final TermId INHERITANCE_ID = TermId.of((String)"HP:0000005");
    private static final TermId CLINICAL_COURSE_ID = TermId.of((String)"HP:0031797");
    private static final TermId ABNORMAL_CELLULAR_ID = TermId.of((String)"HP:0025354");
    private static final TermId BLOOD_ID = TermId.of((String)"HP:0001871");
    private static final TermId CONNECTIVE_TISSUE_ID = TermId.of((String)"HP:0003549");
    private static final TermId HEAD_AND_NECK_ID = TermId.of((String)"HP:0000152");
    private static final TermId LIMBS_ID = TermId.of((String)"HP:0040064");
    private static final TermId METABOLISM_ID = TermId.of((String)"HP:0001939");
    private static final TermId PRENATAL_ID = TermId.of((String)"HP:0001197");
    private static final TermId BREAST_ID = TermId.of((String)"HP:0000769");
    private static final TermId CARDIOVASCULAR_ID = TermId.of((String)"HP:0001626");
    private static final TermId DIGESTIVE_ID = TermId.of((String)"HP:0025031");
    private static final TermId EAR_ID = TermId.of((String)"HP:0000598");
    private static final TermId ENDOCRINE_ID = TermId.of((String)"HP:0000818");
    private static final TermId EYE_ID = TermId.of((String)"HP:0000478");
    private static final TermId GENITOURINARY_ID = TermId.of((String)"HP:0000119");
    private static final TermId IMMUNOLOGY_ID = TermId.of((String)"HP:0002715");
    private static final TermId INTEGUMENT_ID = TermId.of((String)"HP:0001574");
    private static final TermId MUSCLE_ID = TermId.of((String)"HP:0003011");
    private static final TermId NERVOUS_SYSTEM_ID = TermId.of((String)"HP:0000707");
    private static final TermId RESPIRATORY_ID = TermId.of((String)"HP:0002086");
    private static final TermId SKELETAL_ID = TermId.of((String)"HP:0000924");
    private static final TermId THORACIC_CAVITY_ID = TermId.of((String)"HP:0045027");
    private static final TermId VOICE_ID = TermId.of((String)"HP:0001608");
    private static final TermId CONSTITUTIONAL_ID = TermId.of((String)"HP:0025142");
    private static final TermId GROWTH_ID = TermId.of((String)"HP:0001507");
    private static final TermId NEOPLASM_ID = TermId.of((String)"HP:0002664");

    public HpoCategoryMap() {
        HashMap<TermId, HpoCategory> mapbuilder = new HashMap<TermId, HpoCategory>();
        HpoCategory inheritanceCategory = new HpoCategory(INHERITANCE_ID, "Inheritance");
        mapbuilder.put(INHERITANCE_ID, inheritanceCategory);
        HpoCategory abnCellCategory = new HpoCategory(ABNORMAL_CELLULAR_ID, "Cellular phenotype");
        mapbuilder.put(ABNORMAL_CELLULAR_ID, abnCellCategory);
        HpoCategory abnBlood = new HpoCategory(BLOOD_ID, "Blood and blood-forming tissues");
        mapbuilder.put(abnBlood.id(), abnBlood);
        HpoCategory abnConnTiss = new HpoCategory(CONNECTIVE_TISSUE_ID, "Connective tissue");
        mapbuilder.put(abnConnTiss.id(), abnConnTiss);
        HpoCategory headNeckCat = new HpoCategory(HEAD_AND_NECK_ID, "Head and neck");
        mapbuilder.put(HEAD_AND_NECK_ID, headNeckCat);
        HpoCategory limbCat = new HpoCategory(LIMBS_ID, "Limbs");
        mapbuilder.put(LIMBS_ID, limbCat);
        HpoCategory metabolismCat = new HpoCategory(METABOLISM_ID, "Metabolism/Laboratory abnormality");
        mapbuilder.put(METABOLISM_ID, metabolismCat);
        HpoCategory prenatalCat = new HpoCategory(PRENATAL_ID, "Prenatal and Birth");
        mapbuilder.put(PRENATAL_ID, prenatalCat);
        HpoCategory breastCat = new HpoCategory(BREAST_ID, "Breast");
        mapbuilder.put(BREAST_ID, breastCat);
        HpoCategory cardiovascularCat = new HpoCategory(CARDIOVASCULAR_ID, "Cardiovascular");
        mapbuilder.put(CARDIOVASCULAR_ID, cardiovascularCat);
        HpoCategory digestiveCat = new HpoCategory(DIGESTIVE_ID, "Digestive System");
        mapbuilder.put(DIGESTIVE_ID, digestiveCat);
        HpoCategory earCat = new HpoCategory(EAR_ID, "Ear");
        mapbuilder.put(EAR_ID, earCat);
        HpoCategory endocrineCat = new HpoCategory(ENDOCRINE_ID, "Endocrine");
        mapbuilder.put(ENDOCRINE_ID, endocrineCat);
        HpoCategory eyeCat = new HpoCategory(EYE_ID, "Eye");
        mapbuilder.put(EYE_ID, eyeCat);
        HpoCategory guCat = new HpoCategory(GENITOURINARY_ID, "Genitourinary system");
        mapbuilder.put(GENITOURINARY_ID, guCat);
        HpoCategory immuneCat = new HpoCategory(IMMUNOLOGY_ID, "Immunology");
        mapbuilder.put(IMMUNOLOGY_ID, immuneCat);
        HpoCategory integumentCat = new HpoCategory(INTEGUMENT_ID, "Skin, Hair, and Nails");
        mapbuilder.put(INTEGUMENT_ID, integumentCat);
        HpoCategory muscleCat = new HpoCategory(MUSCLE_ID, "Musculature");
        mapbuilder.put(MUSCLE_ID, muscleCat);
        HpoCategory nervousCat = new HpoCategory(NERVOUS_SYSTEM_ID, "Nervous System");
        mapbuilder.put(NERVOUS_SYSTEM_ID, nervousCat);
        HpoCategory respiratoryCat = new HpoCategory(RESPIRATORY_ID, "Respiratory System");
        mapbuilder.put(RESPIRATORY_ID, respiratoryCat);
        HpoCategory skeletalCat = new HpoCategory(SKELETAL_ID, "Skeletal system");
        mapbuilder.put(SKELETAL_ID, skeletalCat);
        HpoCategory thoracicCat = new HpoCategory(THORACIC_CAVITY_ID, "Thoracic cavity");
        mapbuilder.put(THORACIC_CAVITY_ID, thoracicCat);
        HpoCategory voiceCat = new HpoCategory(VOICE_ID, "Voice");
        mapbuilder.put(VOICE_ID, voiceCat);
        HpoCategory constitutionalCat = new HpoCategory(CONSTITUTIONAL_ID, "Constitutional Symptom");
        mapbuilder.put(CONSTITUTIONAL_ID, constitutionalCat);
        HpoCategory growthCat = new HpoCategory(GROWTH_ID, "Growth");
        mapbuilder.put(GROWTH_ID, growthCat);
        HpoCategory neoplasmCat = new HpoCategory(NEOPLASM_ID, "Neoplasm");
        mapbuilder.put(NEOPLASM_ID, neoplasmCat);
        HpoCategory clinicalCourseCat = new HpoCategory(CLINICAL_COURSE_ID, "Clinical course");
        mapbuilder.put(CLINICAL_COURSE_ID, clinicalCourseCat);
        this.categorymap = Map.copyOf(mapbuilder);
    }

    public void addAnnotatedTerm(TermId tid, Ontology ontology) throws PhenolRuntimeException {
        HpoCategory cat = this.getCategory(tid, ontology);
        if (cat == null) {
            this.LOGGER.warn("Could not get upper level HPO category for " + ((Term)ontology.getTermMap().get(tid)).getName());
            return;
        }
        cat.addAnnotatedTerm(tid);
    }

    public void addAnnotatedTerms(List<TermId> tidlist, Ontology ontology) {
        for (TermId tid : tidlist) {
            this.addAnnotatedTerm(tid, ontology);
        }
    }

    private Set<TermId> getAncestorCategories(Ontology ontology, TermId childTermId) {
        HashSet<TermId> builder = new HashSet<TermId>();
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        stack.push(childTermId);
        while (!stack.isEmpty()) {
            TermId tid = (TermId)stack.pop();
            Set parents = OntologyAlgorithm.getParentTerms((Ontology)ontology, (TermId)tid, (boolean)false);
            for (TermId p : parents) {
                if (this.categorymap.containsKey(p)) {
                    builder.add(p);
                    continue;
                }
                stack.add(p);
            }
        }
        return Set.copyOf(builder);
    }

    private HpoCategory getCategory(TermId tid, Ontology ontology) {
        if (tid == null) {
            this.LOGGER.warn("Trying to get HPO Category but input TermId was null...");
            return null;
        }
        Set<TermId> ancs = this.getAncestorCategories(ontology, tid);
        return this.getPrioritizedCategory(ancs);
    }

    private HpoCategory getPrioritizedCategory(Set<TermId> catlist) {
        if (catlist.size() == 1) {
            return this.categorymap.get(catlist.iterator().next());
        }
        if (catlist.stream().anyMatch(t -> t.equals((Object)NEOPLASM_ID))) {
            return this.categorymap.get(NEOPLASM_ID);
        }
        if (catlist.size() == 0) {
            this.LOGGER.warn("Could not find category for {}", catlist);
            return null;
        }
        TermId categoryId = catlist.iterator().next();
        return this.categorymap.get(categoryId);
    }

    private TermId getPrioritizedTid(Set<TermId> ancestors) {
        for (TermId id : ancestors) {
            if (!id.equals((Object)NEOPLASM_ID)) continue;
            return NEOPLASM_ID;
        }
        return ancestors.iterator().next();
    }

    public List<HpoCategory> getActiveCategoryList() {
        ArrayList<HpoCategory> builder = new ArrayList<HpoCategory>(this.termIdList.length);
        for (TermId tid : this.termIdList) {
            HpoCategory cat = this.categorymap.get(tid);
            if (!cat.hasAnnotation()) continue;
            builder.add(cat);
        }
        return Collections.unmodifiableList(builder);
    }
}

