/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.mpo;

import org.monarchinitiative.phenol.annotations.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class MpoGeneAnnotation
implements TermAnnotation {
    private static final long serialVersionUID = 2L;
    private final TermId geneId;
    private final String entrezGeneSymbol;
    private final String hpoTermName;
    private final TermId hpoTermId;

    public MpoGeneAnnotation(TermId gene, String entrezGeneSymbol, String hpoTermName, TermId hpoTermId) {
        this.geneId = gene;
        this.entrezGeneSymbol = entrezGeneSymbol;
        this.hpoTermName = hpoTermName;
        this.hpoTermId = hpoTermId;
    }

    public TermId getGeneId() {
        return this.geneId;
    }

    public String getGeneSymbol() {
        return this.entrezGeneSymbol;
    }

    public String getTermName() {
        return this.hpoTermName;
    }

    public TermId id() {
        return this.hpoTermId;
    }

    public TermId getItemId() {
        return this.geneId;
    }

    public String toString() {
        return "MPOGeneAnnotation [geneId=" + this.geneId.getValue() + ", entrezGeneSymbol=" + this.entrezGeneSymbol + ", termName=" + this.hpoTermName + ", termId=" + this.hpoTermId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.geneId.hashCode();
        result = 31 * result + (this.entrezGeneSymbol == null ? 0 : this.entrezGeneSymbol.hashCode());
        result = 31 * result + (this.hpoTermId == null ? 0 : this.hpoTermId.hashCode());
        result = 31 * result + (this.hpoTermName == null ? 0 : this.hpoTermName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MpoGeneAnnotation other = (MpoGeneAnnotation)obj;
        if (this.geneId != other.geneId) {
            return false;
        }
        if (this.entrezGeneSymbol == null ? other.entrezGeneSymbol != null : !this.entrezGeneSymbol.equals(other.entrezGeneSymbol)) {
            return false;
        }
        if (this.hpoTermId == null ? other.hpoTermId != null : !this.hpoTermId.equals((Object)other.hpoTermId)) {
            return false;
        }
        return !(this.hpoTermName == null ? other.hpoTermName != null : !this.hpoTermName.equals(other.hpoTermName));
    }

    public int compareTo(TermAnnotation o) {
        if (!(o instanceof HpoGeneAnnotation)) {
            throw new RuntimeException("Cannot compare " + o + " to a HpoGeneAnnotation");
        }
        MpoGeneAnnotation that = (MpoGeneAnnotation)o;
        int result = this.geneId.compareTo(that.geneId);
        if (result != 0) {
            return result;
        }
        result = this.entrezGeneSymbol.compareTo(that.entrezGeneSymbol);
        if (result != 0) {
            return result;
        }
        result = this.hpoTermName.compareTo(that.hpoTermName);
        if (result != 0) {
            return result;
        }
        return this.hpoTermId.compareTo(that.hpoTermId);
    }
}

