/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class OrphanetInheritanceXMLParser {
    private final String orphanetXmlPath;
    private final Ontology ontology;
    private final String orphanetBiocurationString;
    private final Map<TermId, Collection<HpoAnnotationEntry>> disease2inheritanceMultimap;
    private static final String DISORDER = "Disorder";
    private static final String ORPHA_NUMBER = "OrphaNumber";
    private static final String TYPE_OF_INHERITANCE_LIST = "TypeOfInheritanceList";
    private static final String TYPE_OF_INHERITANCE = "TypeOfInheritance";
    private static final String NAME = "Name";
    private static final String AVERAGE_AGE_OF_ONSET_LIST = "AverageAgeOfOnsetList";
    private static final String AVERAGE_AGE_OF_DEATH_LIST = "AverageAgeOfDeathList";
    private static final String DISORDER_TYPE = "DisorderType";
    private static final String NOT_APPLICABLE_ID = "409941";
    private static final String UNKNOWN_ID = "409939";
    private static final String NO_DATA_AVAILABLE = "409940";
    private boolean inDisorder = false;
    private boolean inTypeOfInheritanceList = false;
    private boolean inTypeOfInheritance = false;
    private boolean inAverageAgeOfOnsetList = false;
    private boolean isInAverageAgeOfDeathList = false;
    private boolean inDisorderType = false;
    private final List<String> errorlist;

    public OrphanetInheritanceXMLParser(String xmlpath, Ontology onto) {
        this.orphanetXmlPath = xmlpath;
        this.ontology = onto;
        String todaysDate = this.getTodaysDate();
        this.errorlist = new ArrayList<String>();
        this.orphanetBiocurationString = String.format("ORPHA:orphadata[%s]", todaysDate);
        this.disease2inheritanceMultimap = new HashMap<TermId, Collection<HpoAnnotationEntry>>();
        this.parse(new File(this.orphanetXmlPath));
    }

    public Map<TermId, Collection<HpoAnnotationEntry>> getDisease2inheritanceMultimap() {
        return this.disease2inheritanceMultimap;
    }

    private void parse(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            String currentOrphanum = null;
            String currentDiseaseName = null;
            String currentInheritanceId = null;
            String currentModeOfInheritanceLabel = null;
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String localPart = event.asStartElement().getName().getLocalPart();
                    if (localPart.equals(DISORDER)) {
                        this.inDisorder = true;
                    } else if (this.inDisorder && !this.inAverageAgeOfOnsetList && !this.isInAverageAgeOfDeathList && !this.inDisorderType && !this.inTypeOfInheritance && localPart.equals(ORPHA_NUMBER)) {
                        event = eventReader.nextEvent();
                        currentOrphanum = event.asCharacters().getData();
                    } else if (this.inDisorder && localPart.equals(TYPE_OF_INHERITANCE_LIST)) {
                        this.inTypeOfInheritanceList = true;
                    } else if (this.inTypeOfInheritanceList && localPart.equals(TYPE_OF_INHERITANCE)) {
                        this.inTypeOfInheritance = true;
                    } else if (this.inDisorder && !this.inAverageAgeOfOnsetList && !this.isInAverageAgeOfDeathList && !this.inDisorderType && !this.inTypeOfInheritance && localPart.equals(NAME)) {
                        event = eventReader.nextEvent();
                        currentDiseaseName = event.asCharacters().getData();
                    } else if (this.inDisorder && !this.inAverageAgeOfOnsetList && !this.isInAverageAgeOfDeathList && !this.inDisorderType && this.inTypeOfInheritance && localPart.equals(NAME)) {
                        event = eventReader.nextEvent();
                        currentModeOfInheritanceLabel = event.asCharacters().getData();
                        if (currentInheritanceId == null || currentInheritanceId.equals(NOT_APPLICABLE_ID) || currentInheritanceId.equals(UNKNOWN_ID) || currentInheritanceId.equals(NO_DATA_AVAILABLE)) continue;
                        TermId disId = TermId.of((String)String.format("ORPHA:%s", currentOrphanum));
                        TermId hpoInheritanceId = this.getHpoInheritanceTermId(currentInheritanceId, currentModeOfInheritanceLabel);
                        if (hpoInheritanceId == null) continue;
                        if (!this.ontology.getTermMap().containsKey(hpoInheritanceId)) {
                            this.errorlist.add("[WARNING] Could not find HPO label for Orphanet inheritance term" + hpoInheritanceId.getValue());
                            continue;
                        }
                        String hpoLabel = ((Term)this.ontology.getTermMap().get(hpoInheritanceId)).getName();
                        HpoAnnotationEntry entry = HpoAnnotationEntry.fromOrphaInheritanceData(disId.getValue(), currentDiseaseName, hpoInheritanceId, hpoLabel, this.orphanetBiocurationString);
                        this.disease2inheritanceMultimap.computeIfAbsent(disId, key -> new HashSet()).add(entry);
                    } else if (localPart.equals(AVERAGE_AGE_OF_ONSET_LIST)) {
                        this.inAverageAgeOfOnsetList = true;
                    } else if (localPart.equals(AVERAGE_AGE_OF_DEATH_LIST)) {
                        this.isInAverageAgeOfDeathList = true;
                    } else if (localPart.equals(TYPE_OF_INHERITANCE)) {
                        this.inTypeOfInheritance = true;
                    } else if (localPart.equals(DISORDER_TYPE)) {
                        this.inDisorderType = true;
                    }
                    if (!this.inTypeOfInheritance || !localPart.equals(ORPHA_NUMBER)) continue;
                    event = eventReader.nextEvent();
                    currentInheritanceId = event.asCharacters().getData();
                    continue;
                }
                if (!event.isEndElement()) continue;
                EndElement endElement = event.asEndElement();
                String localPart = endElement.getName().getLocalPart();
                if (localPart.equals(DISORDER)) {
                    this.inDisorder = false;
                    continue;
                }
                if (localPart.equals(TYPE_OF_INHERITANCE_LIST)) {
                    this.inTypeOfInheritanceList = false;
                    continue;
                }
                if (localPart.equals(TYPE_OF_INHERITANCE)) {
                    this.inTypeOfInheritance = false;
                    continue;
                }
                if (localPart.equals(AVERAGE_AGE_OF_ONSET_LIST)) {
                    this.inAverageAgeOfOnsetList = false;
                    continue;
                }
                if (localPart.equals(AVERAGE_AGE_OF_DEATH_LIST)) {
                    this.isInAverageAgeOfDeathList = false;
                    continue;
                }
                if (!localPart.equals(DISORDER_TYPE)) continue;
                this.inDisorderType = false;
            }
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
    }

    private TermId getHpoInheritanceTermId(String orphaInheritanceId, String orphaLabel) {
        if (orphaInheritanceId.equals("409930") && orphaLabel.equals("Autosomal recessive")) {
            return HpoModeOfInheritanceTermIds.AUTOSOMAL_RECESSIVE;
        }
        if (orphaInheritanceId.equals("409929") && orphaLabel.equals("Autosomal dominant")) {
            return HpoModeOfInheritanceTermIds.AUTOSOMAL_DOMINANT;
        }
        if (orphaInheritanceId.equals("409931") && orphaLabel.equals("Multigenic/multifactorial")) {
            return HpoModeOfInheritanceTermIds.MULTIFACTORIAL;
        }
        if (orphaInheritanceId.equals("409932") && orphaLabel.equals("X-linked recessive")) {
            return HpoModeOfInheritanceTermIds.X_LINKED_RECESSIVE;
        }
        if (orphaInheritanceId.equals("409933") && orphaLabel.equals("Mitochondrial inheritance")) {
            return HpoModeOfInheritanceTermIds.MITOCHONDRIAL;
        }
        if (orphaInheritanceId.equals("409934") && orphaLabel.equals("X-linked dominant")) {
            return HpoModeOfInheritanceTermIds.X_LINKED_DOMINANT;
        }
        if (orphaInheritanceId.equals("409938") && orphaLabel.equals("Y-linked")) {
            return HpoModeOfInheritanceTermIds.Y_LINKED;
        }
        if (orphaInheritanceId.equals("409937") && orphaLabel.equals("Semi-dominant")) {
            return HpoModeOfInheritanceTermIds.INHERITANCE_ROOT;
        }
        if (orphaInheritanceId.equals("409936") && orphaLabel.equals("Oligogenic")) {
            return HpoModeOfInheritanceTermIds.OLIGOGENIC;
        }
        this.errorlist.add("[WARNING] Could not find HPO id for Orphanet inheritence entry: " + orphaLabel + "(" + orphaInheritanceId + ")");
        return null;
    }

    public boolean hasError() {
        return this.errorlist.size() > 0;
    }

    public List<String> getErrorlist() {
        return this.errorlist;
    }

    private String getTodaysDate() {
        Date date = new Date();
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }
}

