/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.ontology.data.TermId;

class AggregatedHpoDiseaseAnnotation
implements HpoDiseaseAnnotation {
    private final TermId id;
    private final Ratio ratio;
    private final List<TemporalInterval> observationIntervals;
    private final Age earliestOnset;
    private final Age latestOnset;
    private final List<AnnotationReference> references;

    AggregatedHpoDiseaseAnnotation(TermId id, Ratio ratio, Age earliestOnset, Age latestOnset, List<TemporalInterval> observationIntervals, List<AnnotationReference> references) {
        this.id = Objects.requireNonNull(id);
        this.ratio = Objects.requireNonNull(ratio);
        this.observationIntervals = Objects.requireNonNull(observationIntervals);
        this.earliestOnset = earliestOnset;
        this.latestOnset = latestOnset;
        this.references = Objects.requireNonNull(references);
    }

    public TermId id() {
        return this.id;
    }

    @Override
    public Stream<HpoDiseaseAnnotationMetadata> metadata() {
        return Stream.empty();
    }

    @Override
    public Ratio ratio() {
        return this.ratio;
    }

    @Override
    public List<TemporalInterval> observationIntervals() {
        return this.observationIntervals;
    }

    @Override
    public Optional<Ratio> observedInInterval(TemporalInterval target) {
        return Optional.empty();
    }

    @Override
    public Optional<Age> earliestOnset() {
        return Optional.ofNullable(this.earliestOnset);
    }

    @Override
    public Optional<Age> latestOnset() {
        return Optional.ofNullable(this.latestOnset);
    }

    @Override
    public Optional<Age> earliestResolution() {
        return Optional.empty();
    }

    @Override
    public Optional<Age> latestResolution() {
        return Optional.empty();
    }

    @Override
    public List<AnnotationReference> references() {
        return this.references;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedHpoDiseaseAnnotation that = (AggregatedHpoDiseaseAnnotation)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.ratio, that.ratio) && Objects.equals(this.observationIntervals, that.observationIntervals) && Objects.equals(this.earliestOnset, that.earliestOnset) && Objects.equals(this.latestOnset, that.latestOnset) && Objects.equals(this.references, that.references);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.ratio, this.observationIntervals, this.earliestOnset, this.latestOnset, this.references);
    }

    public String toString() {
        return "AggregatedHpoDiseaseAnnotation{id=" + this.id + ", ratio=" + this.ratio + ", observationIntervals=" + this.observationIntervals + ", earliestOnset=" + this.earliestOnset + ", latestOnset=" + this.latestOnset + ", references=" + this.references + "}";
    }
}

