/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.annotations.io.hpo.AggregatedHpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.io.hpo.BaseHpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AggregatedHpoDiseaseLoader
extends BaseHpoDiseaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregatedHpoDiseaseLoader.class);

    AggregatedHpoDiseaseLoader(Ontology hpo, HpoDiseaseLoaderOptions options) {
        super(hpo, options);
    }

    @Override
    protected Optional<HpoDisease> assembleHpoDisease(TermId diseaseId, Iterable<HpoAnnotationLine> annotationLines) {
        Optional<HpoDiseaseData> diseaseDataOptional = this.parseDiseaseData(annotationLines);
        if (diseaseDataOptional.isEmpty()) {
            return Optional.empty();
        }
        HpoDiseaseData diseaseData = diseaseDataOptional.get();
        List<HpoDiseaseAnnotation> phenotypes = diseaseData.phenotypes();
        TemporalInterval onset = AggregatedHpoDiseaseLoader.parseGlobalDiseaseOnset(diseaseData.clinicalCourseTerms(), phenotypes);
        return Optional.of(HpoDisease.of(diseaseId, diseaseData.diseaseName(), onset, phenotypes, Collections.unmodifiableList(diseaseData.modesOfInheritance())));
    }

    private Optional<HpoDiseaseData> parseDiseaseData(Iterable<HpoAnnotationLine> annotationLines) {
        ArrayList<HpoDiseaseAnnotation> phenotypes = new ArrayList<HpoDiseaseAnnotation>();
        LinkedList<TermId> modesOfInheritance = new LinkedList<TermId>();
        ArrayList<TermId> clinicalModifierListBuilder = new ArrayList<TermId>();
        ArrayList<TermId> clinicalCourse = new ArrayList<TermId>();
        String diseaseName = null;
        for (HpoAnnotationLine line : annotationLines) {
            TermId phenotypeId;
            if (line.getDatabaseObjectName() != null) {
                diseaseName = line.getDatabaseObjectName();
            }
            try {
                phenotypeId = TermId.of((String)line.getPhenotypeId());
            }
            catch (PhenolRuntimeException e) {
                LOGGER.warn("Non-parsable phenotype term `{}`: {}", (Object)line.getPhenotypeId(), (Object)e.getMessage());
                continue;
            }
            if (this.inheritanceSubHierarchy.contains(phenotypeId)) {
                modesOfInheritance.add(phenotypeId);
                continue;
            }
            if (this.clinicalCourseSubHierarchy.contains(phenotypeId)) {
                clinicalCourse.add(phenotypeId);
                continue;
            }
            if (phenotypeId.equals((Object)HpoSubOntologyRootTermIds.CLINICAL_MODIFIER)) {
                clinicalModifierListBuilder.add(phenotypeId);
                continue;
            }
            try {
                phenotypes.add(this.createDiseaseAnnotation(phenotypeId, line));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Non-parsable phenotype entry `{}`: {}", (Object)line, (Object)e.getMessage());
            }
        }
        if (diseaseName == null) {
            return Optional.empty();
        }
        return Optional.of(new HpoDiseaseData(diseaseName, phenotypes, modesOfInheritance, clinicalModifierListBuilder, clinicalCourse));
    }

    private HpoDiseaseAnnotation createDiseaseAnnotation(TermId phenotypeId, HpoAnnotationLine line) throws IllegalArgumentException {
        List<TemporalInterval> observationIntervals;
        AnnotationFrequency annotationFrequency = this.parseFrequency(line.isNOT(), line.getFrequency());
        Optional<HpoOnset> onsetOptional = HpoOnset.fromHpoIdString(line.getOnsetId());
        Age earliestOnset = onsetOptional.map(HpoOnset::start).orElse(null);
        Age latestOnset = onsetOptional.map(HpoOnset::end).orElse(null);
        if (onsetOptional.isPresent()) {
            HpoOnset onset = onsetOptional.get();
            observationIntervals = List.of(TemporalInterval.openEnd(onset.start()));
        } else {
            observationIntervals = List.of();
        }
        EvidenceCode evidenceCode = EvidenceCode.parse(line.getEvidence());
        ArrayList<AnnotationReference> references = new ArrayList<AnnotationReference>(line.getPublication().size());
        for (String ref : line.getPublication()) {
            try {
                TermId referenceId = TermId.of((String)ref);
                references.add(AnnotationReference.of(referenceId, evidenceCode));
            }
            catch (PhenolRuntimeException e) {
                LOGGER.warn("Skipping non-parsable reference id {}", (Object)ref);
            }
        }
        if (annotationFrequency.ratio().isEmpty()) {
            throw new IllegalStateException("Annotation frequency must be present!");
        }
        return new AggregatedHpoDiseaseAnnotation(phenotypeId, annotationFrequency.ratio().get(), earliestOnset, latestOnset, observationIntervals, references);
    }

    private static TemporalInterval parseGlobalDiseaseOnset(List<TermId> termIds, List<HpoDiseaseAnnotation> phenotypes) {
        Optional<HpoOnset> earliest = termIds.stream().map(HpoOnset::fromTermId).flatMap(Optional::stream).min(Comparator.comparing(a -> a, TemporalInterval::compare));
        if (earliest.isPresent()) {
            return earliest.get();
        }
        Age earliestOnset = null;
        Age latestOnset = null;
        for (HpoDiseaseAnnotation phenotype : phenotypes) {
            Optional<Age> latest;
            Optional<Age> earliest2 = phenotype.earliestOnset();
            if (earliest2.isPresent()) {
                earliestOnset = earliestOnset == null ? earliest2.get() : Age.min(earliestOnset, earliest2.get());
            }
            if (!(latest = phenotype.latestOnset()).isPresent()) continue;
            if (latestOnset == null) {
                latestOnset = latest.get();
                continue;
            }
            latestOnset = Age.max(latestOnset, latest.get());
        }
        return earliestOnset == null || latestOnset == null ? null : TemporalInterval.of(earliestOnset, latestOnset);
    }

    private static class HpoDiseaseData {
        private final String diseaseName;
        private final List<HpoDiseaseAnnotation> phenotypes;
        private final List<TermId> modesOfInheritance;
        private final List<TermId> clinicalModifiers;
        private final List<TermId> clinicalCourseTerms;

        private HpoDiseaseData(String diseaseName, List<HpoDiseaseAnnotation> phenotypes, List<TermId> modesOfInheritance, List<TermId> clinicalModifiers, List<TermId> clinicalCourseTerms) {
            this.diseaseName = diseaseName;
            this.phenotypes = phenotypes;
            this.modesOfInheritance = modesOfInheritance;
            this.clinicalModifiers = clinicalModifiers;
            this.clinicalCourseTerms = clinicalCourseTerms;
        }

        private String diseaseName() {
            return this.diseaseName;
        }

        private List<HpoDiseaseAnnotation> phenotypes() {
            return this.phenotypes;
        }

        private List<TermId> modesOfInheritance() {
            return this.modesOfInheritance;
        }

        private List<TermId> clinicalModifiers() {
            return this.clinicalModifiers;
        }

        private List<TermId> clinicalCourseTerms() {
            return this.clinicalCourseTerms;
        }
    }
}

