/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderDefault;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.constants.hpo.HpoClinicalModifierTermIds;
import org.monarchinitiative.phenol.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseHpoDiseaseLoader
implements HpoDiseaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoDiseaseLoaderDefault.class);
    private static final Pattern HPO_PATTERN = Pattern.compile("HP:\\d{7}");
    private static final Pattern RATIO_PATTERN = Pattern.compile("(?<numerator>\\d+)/(?<denominator>\\d+)");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("(?<value>\\d+\\.?(\\d+)?)%");
    private final int cohortSize;
    private final boolean salvageNegatedFrequencies;
    protected final Set<String> databasePrefixes;
    protected final Set<TermId> clinicalCourseSubHierarchy;
    protected final Set<TermId> inheritanceSubHierarchy;

    protected BaseHpoDiseaseLoader(Ontology hpo, HpoDiseaseLoaderOptions options) {
        Objects.requireNonNull(hpo, "HPO ontology must not be null.");
        Objects.requireNonNull(options, "Options must not be null.");
        this.cohortSize = options.cohortSize();
        this.salvageNegatedFrequencies = options.salvageNegatedFrequencies();
        this.databasePrefixes = options.includedDatabases().stream().map(DiseaseDatabase::prefix).collect(Collectors.toUnmodifiableSet());
        this.clinicalCourseSubHierarchy = hpo.containsTerm(HpoClinicalModifierTermIds.CLINICAL_COURSE) ? hpo.subOntology(HpoClinicalModifierTermIds.CLINICAL_COURSE).getNonObsoleteTermIds() : Set.of();
        this.inheritanceSubHierarchy = hpo.containsTerm(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT) ? hpo.subOntology(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT).getNonObsoleteTermIds() : Set.of();
    }

    @Override
    public HpoDiseases load(InputStream is) throws IOException {
        Map<TermId, List<HpoAnnotationLine>> disease2AnnotLineMap = this.groupLinesByDiseaseId(is);
        List<HpoDisease> diseases = disease2AnnotLineMap.entrySet().stream().map(entry -> this.assembleHpoDisease((TermId)entry.getKey(), (Iterable)entry.getValue())).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return HpoDiseases.of(diseases);
    }

    private Map<TermId, List<HpoAnnotationLine>> groupLinesByDiseaseId(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        HashMap<TermId, List<HpoAnnotationLine>> annotationLinesByDiseaseId = new HashMap<TermId, List<HpoAnnotationLine>>();
        String line = reader.readLine();
        while (line != null) {
            block5: {
                if (!line.startsWith("#")) {
                    HpoAnnotationLine annotationLine;
                    try {
                        annotationLine = HpoAnnotationLine.constructFromString(line);
                    }
                    catch (PhenolException e) {
                        LOGGER.warn("Error {} while parsing line: {}", (Object)e.getMessage(), (Object)line);
                        break block5;
                    }
                    TermId diseaseId = TermId.of((String)annotationLine.getDiseaseId());
                    if (this.databasePrefixes.contains(diseaseId.getPrefix())) {
                        annotationLinesByDiseaseId.computeIfAbsent(diseaseId, k -> new ArrayList()).add(annotationLine);
                    }
                }
            }
            line = reader.readLine();
        }
        return annotationLinesByDiseaseId;
    }

    protected abstract Optional<HpoDisease> assembleHpoDisease(TermId var1, Iterable<HpoAnnotationLine> var2);

    protected AnnotationFrequency parseFrequency(boolean isNegated, String frequency) throws IllegalArgumentException {
        Matcher matcher;
        boolean notDone = true;
        int numerator = -1;
        int denominator = -1;
        if ("".equals(frequency)) {
            numerator = isNegated ? 0 : 1;
            denominator = 1;
            return AnnotationFrequency.of(Ratio.of(numerator, denominator));
        }
        if (HPO_PATTERN.matcher(frequency).matches()) {
            HpoFrequency hpoFrequency = HpoFrequency.fromTermId(TermId.of((String)frequency));
            numerator = isNegated ? 0 : Math.round(hpoFrequency.frequency() * (float)this.cohortSize);
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone && (matcher = RATIO_PATTERN.matcher(frequency)).matches()) {
            denominator = Integer.parseInt(matcher.group("denominator"));
            int i = Integer.parseInt(matcher.group("numerator"));
            if (isNegated) {
                if (denominator == 0) {
                    denominator = this.cohortSize;
                }
                numerator = i == 0 && this.salvageNegatedFrequencies ? 0 : denominator - i;
            } else {
                numerator = i;
            }
            notDone = false;
        }
        if (notDone && (matcher = PERCENTAGE_PATTERN.matcher(frequency)).matches()) {
            float percentage = Float.parseFloat(matcher.group("value"));
            numerator = Math.round(percentage * (float)this.cohortSize / 100.0f);
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone) {
            throw new IllegalArgumentException();
        }
        return AnnotationFrequency.of(Ratio.of(numerator, denominator));
    }
}

