/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotationFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationMetadata;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.annotations.io.hpo.BaseHpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HpoDiseaseLoaderDefault
extends BaseHpoDiseaseLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoDiseaseLoaderDefault.class);

    HpoDiseaseLoaderDefault(Ontology hpo, HpoDiseaseLoaderOptions options) {
        super(hpo, options);
    }

    @Override
    protected Optional<HpoDisease> assembleHpoDisease(TermId diseaseId, Iterable<HpoAnnotationLine> annotationLines) {
        Optional<HpoDiseaseData> diseaseDataOptional = this.parseDiseaseData(annotationLines);
        if (diseaseDataOptional.isEmpty()) {
            return Optional.empty();
        }
        HpoDiseaseData diseaseData = diseaseDataOptional.get();
        List<HpoAnnotation> phenotypes = diseaseData.phenotypes();
        HpoOnset onset = HpoDiseaseLoaderDefault.parseGlobalDiseaseOnset(diseaseData.clinicalCourseTerms(), phenotypes);
        Map<TermId, List<HpoAnnotation>> phenotypeById = phenotypes.stream().collect(Collectors.groupingBy(HpoAnnotation::id));
        List<HpoDiseaseAnnotation> diseaseAnnotations = phenotypeById.entrySet().stream().map(entry -> HpoDiseaseLoaderDefault.toDiseaseAnnotation((TermId)entry.getKey(), (List)entry.getValue())).collect(Collectors.toUnmodifiableList());
        return Optional.of(HpoDisease.of(diseaseId, diseaseData.diseaseName(), onset, diseaseAnnotations, Collections.unmodifiableList(diseaseData.modesOfInheritance())));
    }

    private Optional<HpoDiseaseData> parseDiseaseData(Iterable<HpoAnnotationLine> annotationLines) {
        ArrayList<HpoAnnotation> phenotypes = new ArrayList<HpoAnnotation>();
        LinkedList<TermId> modesOfInheritance = new LinkedList<TermId>();
        ArrayList<TermId> clinicalModifierListBuilder = new ArrayList<TermId>();
        ArrayList<TermId> clinicalCourse = new ArrayList<TermId>();
        String diseaseName = null;
        for (HpoAnnotationLine line : annotationLines) {
            TermId phenotypeId;
            if (line.getDatabaseObjectName() != null) {
                diseaseName = line.getDatabaseObjectName();
            }
            try {
                phenotypeId = TermId.of((String)line.getPhenotypeId());
            }
            catch (PhenolRuntimeException e) {
                LOGGER.warn("Non-parsable phenotype term `{}`: {}", (Object)line.getPhenotypeId(), (Object)e.getMessage());
                continue;
            }
            if (this.inheritanceSubHierarchy.contains(phenotypeId)) {
                modesOfInheritance.add(phenotypeId);
                continue;
            }
            if (this.clinicalCourseSubHierarchy.contains(phenotypeId)) {
                clinicalCourse.add(phenotypeId);
                continue;
            }
            if (phenotypeId.equals((Object)HpoSubOntologyRootTermIds.CLINICAL_MODIFIER)) {
                clinicalModifierListBuilder.add(phenotypeId);
                continue;
            }
            try {
                phenotypes.add(this.createHpoAnnotation(phenotypeId, line));
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Non-parsable phenotype entry `{}`: {}", (Object)line, (Object)e.getMessage());
            }
        }
        return Optional.of(new HpoDiseaseData(diseaseName, phenotypes, modesOfInheritance, clinicalModifierListBuilder, clinicalCourse));
    }

    private HpoAnnotation createHpoAnnotation(TermId phenotypeId, HpoAnnotationLine line) throws IllegalArgumentException {
        AnnotationFrequency annotationFrequency = this.parseFrequency(line.isNOT(), line.getFrequency());
        HpoOnset onset = HpoOnset.fromHpoIdString(line.getOnsetId()).orElse(null);
        List<TermId> modifiers = Arrays.stream(line.modifiers().split(";")).filter(token -> !token.isBlank()).map(TermId::of).collect(Collectors.toList());
        List<String> citations = line.getPublication();
        EvidenceCode evidenceCode = EvidenceCode.parse(line.getEvidence());
        Sex sex = Sex.parse(line.getSex()).orElse(null);
        return HpoAnnotation.of(phenotypeId, annotationFrequency, onset, modifiers, citations, evidenceCode, sex);
    }

    private static HpoOnset parseGlobalDiseaseOnset(List<TermId> termIds, List<HpoAnnotation> phenotypes) {
        Optional<HpoOnset> earliest = termIds.stream().map(HpoOnset::fromTermId).flatMap(Optional::stream).min(Comparator.comparing(a -> a, TemporalInterval::compare));
        if (earliest.isPresent()) {
            return earliest.get();
        }
        HpoOnset onset = null;
        for (HpoAnnotation phenotype : phenotypes) {
            Optional<HpoOnset> onsetOptional = phenotype.onset();
            if (!onsetOptional.isPresent()) continue;
            HpoOnset candidate = onsetOptional.get();
            if (onset == null) {
                onset = candidate;
                continue;
            }
            int result = TemporalInterval.compare(candidate, onset);
            if (result >= 0) continue;
            onset = candidate;
        }
        return onset;
    }

    private static HpoDiseaseAnnotation toDiseaseAnnotation(TermId phenotypeId, List<HpoAnnotation> annotations) {
        List<HpoDiseaseAnnotationMetadata> metadata = annotations.stream().map(HpoDiseaseLoaderDefault::toHpoDiseaseAnnotationMetadata).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
        return HpoDiseaseAnnotation.of(phenotypeId, metadata);
    }

    private static Collection<HpoDiseaseAnnotationMetadata> toHpoDiseaseAnnotationMetadata(HpoAnnotation annotation) {
        ArrayList<HpoDiseaseAnnotationMetadata> metas = new ArrayList<HpoDiseaseAnnotationMetadata>(annotation.citations().size());
        EvidenceCode evidence = annotation.evidence();
        boolean isFirst = true;
        for (String citation : annotation.citations()) {
            AnnotationReference reference;
            try {
                reference = AnnotationReference.of(TermId.of((String)citation), evidence);
            }
            catch (PhenolRuntimeException e) {
                LOGGER.warn("Skipping invalid citation {} in {}", (Object)citation, (Object)annotation.id());
                continue;
            }
            HpoDiseaseAnnotationMetadata metadata = isFirst ? HpoDiseaseAnnotationMetadata.of(reference, annotation.onset().orElse(null), annotation.annotationFrequency(), annotation.modifiers(), annotation.sex()) : HpoDiseaseAnnotationMetadata.of(reference, null, null, annotation.modifiers(), annotation.sex());
            metas.add(metadata);
            isFirst = false;
        }
        return metas;
    }

    private static class HpoDiseaseData {
        private final String diseaseName;
        private final List<HpoAnnotation> phenotypes;
        private final List<TermId> modesOfInheritance;
        private final List<TermId> clinicalModifiers;
        private final List<TermId> clinicalCourseTerms;

        private HpoDiseaseData(String diseaseName, List<HpoAnnotation> phenotypes, List<TermId> modesOfInheritance, List<TermId> clinicalModifiers, List<TermId> clinicalCourseTerms) {
            this.diseaseName = diseaseName;
            this.phenotypes = phenotypes;
            this.modesOfInheritance = modesOfInheritance;
            this.clinicalModifiers = clinicalModifiers;
            this.clinicalCourseTerms = clinicalCourseTerms;
        }

        private String diseaseName() {
            return this.diseaseName;
        }

        private List<HpoAnnotation> phenotypes() {
            return this.phenotypes;
        }

        private List<TermId> modesOfInheritance() {
            return this.modesOfInheritance;
        }

        private List<TermId> clinicalModifiers() {
            return this.clinicalModifiers;
        }

        private List<TermId> clinicalCourseTerms() {
            return this.clinicalCourseTerms;
        }
    }
}

