/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLineOld;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermIds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HpoDiseaseAnnotationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(HpoDiseaseAnnotationParser.class);
    private static final Set<DiseaseDatabase> DEFAULT_DATABASE_PREFIXES = Set.of(DiseaseDatabase.OMIM, DiseaseDatabase.ORPHANET, DiseaseDatabase.DECIPHER);
    private final Path annotationFilePath;
    private final Ontology ontology;
    private final Map<TermId, HpoDisease> diseaseMap;
    private Map<TermId, List<TermId>> phenotypeToDiseaseMap;
    private List<String> errors;
    private final Set<DiseaseDatabase> databasePrefixes;

    public static Map<TermId, HpoDisease> loadDiseaseMap(Path annotationFile, Ontology ontology) {
        return HpoDiseaseAnnotationParser.loadDiseaseMap(annotationFile, ontology, DEFAULT_DATABASE_PREFIXES);
    }

    public static Map<TermId, HpoDisease> loadDiseaseMap(Path annotationFile, Ontology ontology, Set<DiseaseDatabase> databases) {
        HpoDiseaseAnnotationParser parser = new HpoDiseaseAnnotationParser(annotationFile, ontology, databases);
        try {
            return parser.parse();
        }
        catch (PhenolException e) {
            LOGGER.error("Could not load HPO annotations at {}: {}", (Object)annotationFile, (Object)e.getMessage());
            throw new PhenolRuntimeException("Could not load HPO annotations at " + String.valueOf(annotationFile));
        }
    }

    public static Map<TermId, List<TermId>> loadTermToDiseaseMap(Path annotationFile, Ontology ontology, Set<DiseaseDatabase> databasePrefixes) {
        HpoDiseaseAnnotationParser parser = new HpoDiseaseAnnotationParser(annotationFile, ontology, databasePrefixes);
        try {
            parser.parse();
            return parser.getTermToDiseaseMap();
        }
        catch (PhenolException e) {
            System.err.println("Could not load HPO annotations at " + String.valueOf(annotationFile) + ": " + e.getMessage());
            throw new PhenolRuntimeException("Could not load HPO annotations at " + String.valueOf(annotationFile));
        }
    }

    private HpoDiseaseAnnotationParser(Path annotationFile, Ontology ontology, Set<DiseaseDatabase> databases) {
        this.annotationFilePath = annotationFile;
        this.ontology = ontology;
        this.databasePrefixes = databases;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
    }

    public boolean validParse() {
        return this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private Map<TermId, List<TermId>> getTermToDiseaseMap() {
        return this.phenotypeToDiseaseMap;
    }

    public Map<TermId, HpoDisease> parse() throws PhenolException {
        HashMap<TermId, List> disease2AnnotLineMap = new HashMap<TermId, List>();
        HashMap<TermId, List> termToDisease = new HashMap<TermId, List>();
        this.errors = new ArrayList<String>();
        try (BufferedReader br = Files.newBufferedReader(this.annotationFilePath);){
            String line = br.readLine();
            while (line.startsWith("#")) {
                line = br.readLine();
            }
            while ((line = br.readLine()) != null) {
                HpoAnnotationLineOld aline = HpoAnnotationLineOld.constructFromString(line);
                if (!aline.hasValidNumberOfFields()) {
                    this.errors.add(String.format("Invalid number of fields: %s", line));
                    continue;
                }
                List ids = termToDisease.computeIfAbsent(aline.getDiseaseTermId().get(), k -> new ArrayList());
                Optional<TermId> diseaseIdOptional = aline.getDiseaseTermId();
                if (!diseaseIdOptional.isPresent()) continue;
                TermId diseaseId = diseaseIdOptional.get();
                if (!ids.contains(diseaseId)) {
                    ids.add(diseaseId);
                }
                disease2AnnotLineMap.computeIfAbsent(diseaseId, k -> new ArrayList()).add(aline);
            }
            this.phenotypeToDiseaseMap = Map.copyOf(termToDisease);
        }
        catch (IOException e) {
            throw new PhenolException(String.format("Could not read annotation file: %s", e.getMessage()));
        }
        for (TermId diseaseId : disease2AnnotLineMap.keySet()) {
            String diseaseDatabasePrefix = diseaseId.getPrefix();
            DiseaseDatabase diseaseDb = DiseaseDatabase.fromString(diseaseDatabasePrefix);
            if (!this.databasePrefixes.contains((Object)diseaseDb)) continue;
            List annots = (List)disease2AnnotLineMap.get(diseaseId);
            ArrayList<HpoAnnotationLine> phenoListBuilder = new ArrayList<HpoAnnotationLine>();
            ArrayList<TermId> inheritanceListBuilder = new ArrayList<TermId>();
            ArrayList<TermId> negativeTermListBuilder = new ArrayList<TermId>();
            ArrayList<TermId> clinicalModifierListBuilder = new ArrayList<TermId>();
            ArrayList<TermId> clinicalCourseListBuilder = new ArrayList<TermId>();
            String diseaseName = null;
            for (HpoAnnotationLineOld line : annots) {
                try {
                    TermId phenotypeId = TermId.of((String)line.getPhenotypeId());
                    if (this.isInheritanceTerm(phenotypeId)) {
                        inheritanceListBuilder.add(phenotypeId);
                    } else if (this.isClinicalModifierTerm(phenotypeId)) {
                        clinicalModifierListBuilder.add(phenotypeId);
                    } else if (this.isClinicalCourse(phenotypeId)) {
                        clinicalCourseListBuilder.add(phenotypeId);
                    } else if (line.isNOT()) {
                        negativeTermListBuilder.add(phenotypeId);
                    } else {
                        HpoAnnotationLine tidm = HpoAnnotationLineOld.toHpoAnnotation(line, this.ontology);
                        phenoListBuilder.add(tidm);
                    }
                    if (line.getDatabaseObjectName() == null) continue;
                    diseaseName = line.getDatabaseObjectName();
                }
                catch (Exception e) {
                    this.errors.add(String.format("PHENOL ERROR] Line: %s--could not parse annotation: %s ", line.toString(), e.getMessage()));
                }
            }
        }
        return this.diseaseMap;
    }

    private boolean isInheritanceTerm(TermId tid) {
        return tid.equals((Object)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT);
    }

    private boolean isClinicalModifierTerm(TermId tid) {
        TermId CLINICAL_MODIFIER_ROOT = TermId.of((String)"HP:0012823");
        return tid.equals((Object)CLINICAL_MODIFIER_ROOT) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)CLINICAL_MODIFIER_ROOT);
    }

    private boolean isClinicalCourse(TermId tid) {
        TermId CLINICAL_COURSE = TermId.of((String)"HP:0031797");
        return tid.equals((Object)CLINICAL_COURSE) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)CLINICAL_COURSE);
    }

    public static Map<TermId, Collection<TermId>> diseaseIdToDirectHpoTermIds(Map<TermId, HpoDisease> diseaseMap) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List hpoTerms = disease.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
            tmpMap.put(diseaseId, hpoTerms);
        }
        return Map.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> hpoTermIdToDiseaseIdsDirect(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List hpoTermIds = disease.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
            for (TermId tid : hpoTermIds) {
                tmpMap.putIfAbsent(tid, new HashSet());
                ((Collection)tmpMap.get(tid)).add(diseaseId);
            }
        }
        return Map.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> diseaseIdToPropagatedHpoTermIds(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            tmpMap.putIfAbsent(diseaseId, new HashSet());
            List hpoTerms = disease.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
            Set inclAncestorTermIds = TermIds.augmentWithAncestors((Ontology)ontology, new HashSet(hpoTerms), (boolean)true);
            for (TermId tid : inclAncestorTermIds) {
                ((Collection)tmpMap.get(diseaseId)).add(tid);
            }
        }
        return Map.copyOf(tmpMap);
    }

    public static Map<TermId, Collection<TermId>> hpoTermIdToDiseaseIdsPropagated(Map<TermId, HpoDisease> diseaseMap, Ontology ontology) {
        HashMap tmpMap = new HashMap();
        for (TermId diseaseId : diseaseMap.keySet()) {
            HpoDisease disease = diseaseMap.get(diseaseId);
            List hpoTermIds = disease.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
            Set inclAncestorTermIds = TermIds.augmentWithAncestors((Ontology)ontology, new HashSet(hpoTermIds), (boolean)true);
            for (TermId tid : inclAncestorTermIds) {
                tmpMap.putIfAbsent(tid, new HashSet());
                ((Collection)tmpMap.get(tid)).add(diseaseId);
            }
        }
        return Map.copyOf(tmpMap);
    }
}

