/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationRecord;
import org.monarchinitiative.phenol.annotations.formats.hpo.annotation_impl.HpoDiseaseAnnotationRecordBacked;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDiseaseAnnotation
extends Identified,
Comparable<HpoDiseaseAnnotation> {
    public static final Comparator<HpoDiseaseAnnotation> COMPARE_BY_ID = Comparator.comparing(Identified::id);

    public static HpoDiseaseAnnotation of(TermId id, Collection<HpoDiseaseAnnotationRecord> records) {
        return HpoDiseaseAnnotationRecordBacked.of(id, records);
    }

    public Ratio ratio();

    public Optional<PointInTime> earliestOnset();

    public Optional<PointInTime> latestOnset();

    public Optional<PointInTime> earliestResolution();

    public Optional<PointInTime> latestResolution();

    public int observedInInterval(TemporalInterval var1);

    public List<TermId> modifiers();

    public List<AnnotationReference> references();

    default public float frequency() {
        return this.ratio().frequency();
    }

    default public boolean isAbsent() {
        return this.ratio().isZero();
    }

    default public boolean isPresent() {
        return !this.isAbsent();
    }

    public static int compareById(HpoDiseaseAnnotation x, HpoDiseaseAnnotation y) {
        return COMPARE_BY_ID.compare(x, y);
    }

    @Override
    @Deprecated(forRemoval=true)
    default public int compareTo(HpoDiseaseAnnotation other) {
        return COMPARE_BY_ID.compare(this, other);
    }

    @Deprecated(since="2.0.0-RC1", forRemoval=true)
    default public TermId termId() {
        return this.id();
    }

    @Deprecated(forRemoval=true, since="2.0.0")
    default public Iterable<TemporalInterval> observationIntervals() {
        return null;
    }
}

