/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.assoc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.assoc.GeneIdentifierLoader;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifiers;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HGNCGeneIdentifierLoader
implements GeneIdentifierLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HGNCGeneIdentifierLoader.class);
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private static final HGNCGeneIdentifierLoader INSTANCE = new HGNCGeneIdentifierLoader();

    HGNCGeneIdentifierLoader() {
    }

    static HGNCGeneIdentifierLoader instance() {
        return INSTANCE;
    }

    @Override
    public GeneIdentifiers load(Reader reader) throws IOException {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        List<GeneIdentifier> identifiers = br.lines().skip(1L).map(HGNCGeneIdentifierLoader.toGeneIdentifier()).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return GeneIdentifiers.of(identifiers);
    }

    private static Function<String, Optional<GeneIdentifier>> toGeneIdentifier() {
        return line -> {
            String[] token = line.split("\t", 53);
            String id = token[18];
            if (id.isBlank()) {
                LOGGER.debug("Skipping line with missing Entrez ID '{}'", line);
                return Optional.empty();
            }
            TermId entrezId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)id);
            String symbol = token[1];
            return Optional.of(GeneIdentifier.of(entrezId, symbol));
        };
    }
}

