/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;

class PointsInTime {
    static final PointInTime LMP = new ClosedPointInTime.GestationalClosedPointInTime(0);
    static final PointInTime BIRTH = new ClosedPointInTime.PostnatalClosedPointInTime(0);
    static final PointInTime OPEN_START = new OpenPointInTime(Integer.MIN_VALUE, true);
    static final PointInTime OPEN_END = new OpenPointInTime(Integer.MAX_VALUE, false);

    private PointsInTime() {
    }

    static PointInTime of(int days, boolean isGestational) {
        return isGestational ? (days == 0 ? LMP : new ClosedPointInTime.GestationalClosedPointInTime(days)) : (days == 0 ? BIRTH : new ClosedPointInTime.PostnatalClosedPointInTime(days));
    }

    private static class ClosedPointInTime {
        private ClosedPointInTime() {
        }

        private static class PostnatalClosedPointInTime
        implements PointInTime {
            private final int days;

            private PostnatalClosedPointInTime(int days) {
                this.days = days;
            }

            @Override
            public int days() {
                return this.days;
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public boolean isGestational() {
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.days, this.isOpen(), this.isGestational());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PostnatalClosedPointInTime that = (PostnatalClosedPointInTime)o;
                return this.days == that.days;
            }

            public String toString() {
                return "PointInTime{days=" + this.days + ", isGestational=false, isOpen=false}";
            }
        }

        private static class GestationalClosedPointInTime
        implements PointInTime {
            private final int days;

            private GestationalClosedPointInTime(int days) {
                this.days = days;
            }

            @Override
            public int days() {
                return this.days;
            }

            @Override
            public boolean isOpen() {
                return false;
            }

            @Override
            public boolean isGestational() {
                return true;
            }

            public int hashCode() {
                return Objects.hash(this.days, this.isOpen(), this.isGestational());
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                GestationalClosedPointInTime that = (GestationalClosedPointInTime)o;
                return this.days == that.days;
            }

            public String toString() {
                return "PointInTime{days=" + this.days + ", isGestational=true, isOpen=false}";
            }
        }
    }

    static class OpenPointInTime
    implements PointInTime {
        private final int days;
        private final boolean isGestational;

        OpenPointInTime(int days, boolean isGestational) {
            this.days = days;
            this.isGestational = isGestational;
        }

        @Override
        public int days() {
            return this.days;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean isGestational() {
            return this.isGestational;
        }

        public int hashCode() {
            return Objects.hash(this.days, this.isOpen(), this.isGestational());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpenPointInTime that = (OpenPointInTime)o;
            return this.days == that.days && this.isGestational == that.isGestational;
        }

        public String toString() {
            return "OpenPointInTime{days=" + this.days + ", isGestational=" + this.isGestational + "}";
        }
    }
}

