/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModelException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class OrphanetXML2HpoDiseaseModelParser {
    private static final Logger logger = LoggerFactory.getLogger(OrphanetXML2HpoDiseaseModelParser.class);
    private final String orphanetXmlPath;
    private final Ontology ontology;
    private final String orphanetBiocurationString;
    private final Map<TermId, HpoAnnotationModel> orphanetDiseaseMap = new HashMap<TermId, HpoAnnotationModel>();
    private final boolean replaceObsoleteTermId;
    private static final String DISORDER = "Disorder";
    private static final String ORPHA_NUMBER = "OrphaNumber";
    private static final String ORPHA_CODE = "OrphaCode";
    private static final String NAME = "Name";
    private static final String HPO_DISORDER_ASSOCIATION = "HPODisorderAssociation";
    private static final String DIAGNOSTIC_CRITERIA = "DiagnosticCriteria";
    private static final String DISORDER_TYPE = "DisorderType";
    private static final String DISORDER_GROUP = "DisorderGroup";
    private static final String EXPERT_LINK = "ExpertLink";
    private static final String HPO_DISORDER_ASSOCIATION_LIST = "HPODisorderAssociationList";
    private static final String HPO_DISORDER_SET_STATUS = "HPODisorderSetStatus";
    private static final String HPO_DISORDER_SET_STATUS_LIST = "HPODisorderSetStatusList";
    private static final String HPO_FREQUENCY = "HPOFrequency";
    private static final String HPO = "HPO";
    private static final String HPO_ID = "HPOId";
    private static final String HPO_TERM = "HPOTerm";
    private static final String JDBOR = "JDBOR";
    private static final String AVAILABILITY = "Availability";
    private static final String FULL_NAME = "FullName";
    private static final String SHORT_IDENTIFIER = "ShortIdentifier";
    private static final String LEGAL_CODE = "LegalCode";
    private static final String LICENSE = "Licence";
    private static final String SOURCE = "Source";
    private static final String VALIDATION_DATE = "ValidationDate";
    private static final String VALIDATION_STATUS = "ValidationStatus";
    private static final String ONLINE = "Online";
    private final Set<String> allowableXmlNodeNames = Stream.of("Availability", "DiagnosticCriteria", "Disorder", "DisorderGroup", "DisorderType", "ExpertLink", "FullName", "HPODisorderAssociation", "HPODisorderAssociationList", "HPODisorderSetStatus", "HPODisorderSetStatusList", "HPOFrequency", "HPOId", "HPO", "HPOTerm", "JDBOR", "LegalCode", "Licence", "Name", "Online", "OrphaCode", "OrphaNumber", "Source", "ShortIdentifier", "ValidationDate", "ValidationStatus").collect(Collectors.toCollection(HashSet::new));

    public OrphanetXML2HpoDiseaseModelParser(String xmlpath, Ontology onto, boolean tolerant) {
        this.orphanetXmlPath = xmlpath;
        this.ontology = onto;
        this.replaceObsoleteTermId = tolerant;
        String todaysDate = this.getTodaysDate();
        this.orphanetBiocurationString = String.format("ORPHA:orphadata[%s]", todaysDate);
        try {
            this.parse();
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Map<TermId, HpoAnnotationModel> getOrphanetDiseaseMap() {
        return this.orphanetDiseaseMap;
    }

    private TermId string2frequency(String fstring) throws PhenolRuntimeException {
        switch (fstring) {
            case "28405": {
                return HpoFrequencyTermIds.OBLIGATE;
            }
            case "28412": {
                return HpoFrequencyTermIds.VERY_FREQUENT;
            }
            case "28419": {
                return HpoFrequencyTermIds.FREQUENT;
            }
            case "28426": {
                return HpoFrequencyTermIds.OCCASIONAL;
            }
            case "28433": {
                return HpoFrequencyTermIds.VERY_RARE;
            }
            case "28440": {
                return HpoFrequencyTermIds.EXCLUDED;
            }
        }
        throw new PhenolRuntimeException("[ERROR] Could not find TermId for Orphanet frequency {}. This indicates a serious and unexpected error, please report to the developers" + fstring);
    }

    private void parse() throws XMLStreamException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new FileInputStream(this.orphanetXmlPath));
        boolean inFrequency = false;
        boolean inDiagnosticCriterion = false;
        boolean inDisorderType = false;
        boolean inDisorderGroup = false;
        String currentHpoId = null;
        String currentHpoTermLabel = null;
        TermId currentFrequencyTermId = null;
        String currentOrphanumber = null;
        String currentDiseaseName = null;
        ArrayList<HpoAnnotationEntry> currentAnnotationEntryList = new ArrayList<HpoAnnotationEntry>();
        while (xmlEventReader.hasNext()) {
            String localPart;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                String localName = startElement.getName().getLocalPart();
                if (!this.allowableXmlNodeNames.contains(localName)) {
                    throw new PhenolRuntimeException("Unexpected XML Node in Orphanet product_4 XML: " + localName);
                }
                switch (localName) {
                    case "DisorderType": {
                        inDisorderType = true;
                        break;
                    }
                    case "OrphaCode": {
                        if (inFrequency || inDiagnosticCriterion) break;
                        xmlEvent = xmlEventReader.nextEvent();
                        currentOrphanumber = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "Name": {
                        if (inFrequency || inDiagnosticCriterion || inDisorderGroup || inDisorderType) break;
                        xmlEvent = xmlEventReader.nextEvent();
                        currentDiseaseName = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "DisorderGroup": {
                        inDisorderGroup = true;
                        break;
                    }
                    case "HPOId": {
                        xmlEvent = xmlEventReader.nextEvent();
                        currentHpoId = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "HPOTerm": {
                        xmlEvent = xmlEventReader.nextEvent();
                        currentHpoTermLabel = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "HPOFrequency": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr != null) {
                            currentFrequencyTermId = this.string2frequency(idAttr.getValue());
                        }
                        inFrequency = true;
                        break;
                    }
                    case "DiagnosticCriteria": {
                        inDiagnosticCriterion = true;
                        break;
                    }
                    case "HPO": {
                        break;
                    }
                    case "JDBOR": {
                        break;
                    }
                }
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            EndElement endElement = xmlEvent.asEndElement();
            switch (localPart = endElement.getName().getLocalPart()) {
                case "HPOFrequency": {
                    inFrequency = false;
                    break;
                }
                case "DiagnosticCriteria": {
                    inDiagnosticCriterion = false;
                    break;
                }
                case "HPODisorderAssociation": {
                    try {
                        HpoAnnotationEntry entry = HpoAnnotationEntry.fromOrphaData(String.format("ORPHA:%s", currentOrphanumber), currentDiseaseName, currentHpoId, currentHpoTermLabel, currentFrequencyTermId, this.ontology, this.orphanetBiocurationString, this.replaceObsoleteTermId);
                        currentHpoId = null;
                        currentHpoTermLabel = null;
                        currentFrequencyTermId = null;
                        currentAnnotationEntryList.add(entry);
                    }
                    catch (HpoAnnotationModelException e) {
                        logger.warn(String.format("Parse error for %s [ORPHA:%s] HPOid: %s (%s)", currentDiseaseName != null ? currentDiseaseName : "n/a", currentOrphanumber != null ? currentOrphanumber : "n/a", currentHpoId != null ? currentHpoId : "n/a", e.getMessage()));
                    }
                    break;
                }
                case "DisorderGroup": {
                    inDisorderGroup = false;
                    break;
                }
                case "DisorderType": {
                    inDisorderType = false;
                    break;
                }
                case "Disorder": {
                    TermId orphaDiseaseId = TermId.of((String)String.format("ORPHA:%s", currentOrphanumber));
                    HpoAnnotationModel model = new HpoAnnotationModel(String.format("ORPHA:%s", currentOrphanumber), currentAnnotationEntryList);
                    this.orphanetDiseaseMap.put(orphaDiseaseId, model);
                    inDisorderType = false;
                    currentOrphanumber = null;
                    currentDiseaseName = null;
                    currentAnnotationEntryList.clear();
                }
            }
        }
    }

    private String getTodaysDate() {
        Date date = new Date();
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }
}

