/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base;

import org.monarchinitiative.phenol.annotations.base.RatioDefault;

public interface Ratio {
    public static Ratio of(int numerator, int denominator) {
        if (numerator < 0) {
            throw new IllegalArgumentException("Numerator must be non-negative");
        }
        if (denominator <= 0) {
            throw new IllegalArgumentException("Denominator must be positive");
        }
        if (numerator > denominator) {
            throw new IllegalArgumentException("Numerator " + numerator + " must be less than or equal to denominator " + denominator);
        }
        return new RatioDefault(numerator, denominator);
    }

    public int numerator();

    public int denominator();

    default public float frequency() {
        return (float)this.numerator() / (float)this.denominator();
    }

    default public boolean isZero() {
        return this.numerator() == 0;
    }

    default public boolean isPositive() {
        return this.numerator() > 0;
    }

    public static Ratio sum(Ratio left, Ratio right) {
        return Ratio.of(left.numerator() + right.numerator(), left.denominator() + right.denominator());
    }

    public static int compareByFrequency(Ratio left, Ratio right) {
        return Float.compare(left.frequency(), right.frequency());
    }
}

