/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.AgeRangeDefault;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;

public interface AgeRange
extends TemporalInterval {
    public static AgeRange of(Age start, Age end) {
        int result = Age.compare(start, end);
        if (result > 0) {
            throw new IllegalArgumentException(String.format("Start (%d days) must not be after end (%d days)", start.days(), end.days()));
        }
        return AgeRangeDefault.of(start, end);
    }

    public static AgeRange openStart(Age end) {
        return AgeRangeDefault.of(Age.openStart(), end);
    }

    public static AgeRange openEnd(Age start) {
        return AgeRangeDefault.of(start, Age.openEnd());
    }

    public static AgeRange open() {
        return AgeRange.of(Age.openStart(), Age.openEnd());
    }

    @Override
    public Age start();

    @Override
    public Age end();

    default public boolean isPrecise() {
        return this.start().isPrecise() && this.end().isPrecise();
    }

    default public boolean isImprecise() {
        return !this.isPrecise();
    }

    public static int compare(AgeRange x, AgeRange y) {
        int result = Age.compare(x.start(), y.start());
        if (result != 0) {
            return result;
        }
        return Age.compare(x.end(), y.end());
    }
}

