/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.monarchinitiative.phenol.annotations.formats.GeneIdentifier;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class GeneIdentifiers
implements Iterable<GeneIdentifier> {
    private final List<GeneIdentifier> geneIdentifiers;
    private volatile Map<TermId, String> geneIdToSymbol = null;
    private volatile Map<TermId, GeneIdentifier> geneIdToGeneIdentifier = null;
    private volatile Map<String, GeneIdentifier> symbolToGeneIdentifier = null;

    public static GeneIdentifiers of(List<GeneIdentifier> geneIdentifiers) {
        return new GeneIdentifiers(geneIdentifiers);
    }

    private GeneIdentifiers(List<GeneIdentifier> geneIdentifiers) {
        this.geneIdentifiers = Objects.requireNonNull(geneIdentifiers, "Gene identifiers must not be null");
    }

    @Deprecated(forRemoval=true)
    public List<GeneIdentifier> geneIdentifiers() {
        return this.geneIdentifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GeneIdentifier> geneIdById(TermId geneId) {
        if (this.geneIdToGeneIdentifier == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.geneIdToGeneIdentifier == null) {
                    this.geneIdToGeneIdentifier = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::id, Function.identity()));
                }
            }
        }
        return Optional.ofNullable(this.geneIdToGeneIdentifier.get(geneId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public Map<TermId, String> geneIdToSymbol() {
        if (this.geneIdToSymbol == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.geneIdToSymbol == null) {
                    this.geneIdToSymbol = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::id, GeneIdentifier::symbol));
                }
            }
        }
        return this.geneIdToSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<GeneIdentifier> geneIdBySymbol(String symbol) {
        if (this.symbolToGeneIdentifier == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.symbolToGeneIdentifier == null) {
                    this.symbolToGeneIdentifier = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::symbol, Function.identity()));
                }
            }
        }
        return Optional.ofNullable(this.symbolToGeneIdentifier.get(symbol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public Map<String, GeneIdentifier> symbolToGeneIdentifier() {
        if (this.symbolToGeneIdentifier == null) {
            GeneIdentifiers geneIdentifiers = this;
            synchronized (geneIdentifiers) {
                if (this.symbolToGeneIdentifier == null) {
                    this.symbolToGeneIdentifier = this.geneIdentifiers.stream().collect(Collectors.toUnmodifiableMap(GeneIdentifier::symbol, Function.identity()));
                }
            }
        }
        return this.symbolToGeneIdentifier;
    }

    @Override
    public Iterator<GeneIdentifier> iterator() {
        return this.geneIdentifiers.iterator();
    }

    public Stream<GeneIdentifier> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int size() {
        return this.geneIdentifiers.size();
    }
}

