/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo.category;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.formats.hpo.category.HpoCategories;
import org.monarchinitiative.phenol.graph.OntologyGraph;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoCategoryLookup {
    private final OntologyGraph<TermId> graph;
    private final Term[] categories;

    public HpoCategoryLookup(OntologyGraph<TermId> graph, Term[] categories) {
        this.graph = graph;
        this.categories = categories;
    }

    public Optional<Term> getPrioritizedCategory(TermId termId) {
        List<Term> categories = this.getCategoriesForId(termId);
        if (categories.isEmpty()) {
            return Optional.empty();
        }
        if (categories.stream().anyMatch(t -> t.equals((Object)HpoCategories.NEOPLASM))) {
            return Optional.of(HpoCategories.NEOPLASM);
        }
        return Optional.of(categories.get(0));
    }

    private List<Term> getCategoriesForId(TermId termId) {
        Set ancestors = this.graph.getAncestorSet((Object)termId);
        ancestors.add(termId);
        return Arrays.stream(this.categories).filter(c -> ancestors.stream().anyMatch(t -> t.equals((Object)c.id()))).collect(Collectors.toList());
    }
}

