/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItemContainer;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseData;
import org.monarchinitiative.phenol.ontology.data.Versioned;

public class HpoaDiseaseDataContainer
implements AnnotatedItemContainer<HpoaDiseaseData>,
Versioned {
    private final String version;
    private final String hpoVersion;
    private final List<HpoaDiseaseData> diseaseData;

    HpoaDiseaseDataContainer(String version, String hpoVersion, List<HpoaDiseaseData> diseaseData) {
        this.version = version;
        this.hpoVersion = hpoVersion;
        this.diseaseData = Objects.requireNonNull(diseaseData);
    }

    @Override
    public Iterator<HpoaDiseaseData> iterator() {
        return this.diseaseData.iterator();
    }

    public List<HpoaDiseaseData> diseaseData() {
        return this.diseaseData;
    }

    public Optional<String> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> getHpoVersion() {
        return Optional.ofNullable(this.hpoVersion);
    }
}

