/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.AgeRange;

class AgeRangeDefault
implements AgeRange {
    private final Age start;
    private final Age end;

    static AgeRange of(Age start, Age end) {
        if (start.isOpen() || end.isOpen()) {
            if (!start.isOpen()) {
                return new AgeRangeOpenEnd(start);
            }
            if (!end.isOpen()) {
                return new AgeRangeOpenStart(end);
            }
            return AgeRangeOpen.instance();
        }
        return new AgeRangeDefault(start, end);
    }

    private AgeRangeDefault(Age start, Age end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public Age start() {
        return this.start;
    }

    @Override
    public Age end() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgeRangeDefault that = (AgeRangeDefault)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "AgeRangeDefault{start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + "}";
    }

    private static class AgeRangeOpen
    implements AgeRange {
        private static final AgeRangeOpen INSTANCE = new AgeRangeOpen();

        static AgeRangeOpen instance() {
            return INSTANCE;
        }

        private AgeRangeOpen() {
        }

        @Override
        public Age start() {
            return Age.openStart();
        }

        @Override
        public Age end() {
            return Age.openEnd();
        }

        public String toString() {
            return "AgeRangeOpen";
        }
    }

    private static class AgeRangeOpenStart
    implements AgeRange {
        private final Age end;

        private AgeRangeOpenStart(Age end) {
            this.end = end;
        }

        @Override
        public Age start() {
            return Age.openStart();
        }

        @Override
        public Age end() {
            return this.end;
        }

        public int hashCode() {
            return Objects.hash(this.end);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgeRangeOpenStart that = (AgeRangeOpenStart)o;
            return Objects.equals(this.end, that.end);
        }

        public String toString() {
            return "AgeRangeOpenStart{end=" + String.valueOf(this.end) + "}";
        }
    }

    private static class AgeRangeOpenEnd
    implements AgeRange {
        private final Age start;

        private AgeRangeOpenEnd(Age start) {
            this.start = start;
        }

        @Override
        public Age start() {
            return this.start;
        }

        @Override
        public Age end() {
            return Age.openEnd();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AgeRangeOpenEnd that = (AgeRangeOpenEnd)o;
            return Objects.equals(this.start, that.start);
        }

        public int hashCode() {
            return Objects.hash(this.start);
        }

        public String toString() {
            return "AgeRangeOpenEnd{start=" + String.valueOf(this.start) + "}";
        }
    }
}

