/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;

public class ConfidenceRange
implements Comparable<ConfidenceRange> {
    private static final ConfidenceRange PRECISE = new ConfidenceRange(0, 0);
    private final int lowerBound;
    private final int upperBound;

    public static ConfidenceRange precise() {
        return PRECISE;
    }

    public static ConfidenceRange of(int lowerBound, int upperBound) {
        if (lowerBound == 0 && upperBound == 0) {
            return PRECISE;
        }
        return new ConfidenceRange(lowerBound, upperBound);
    }

    private ConfidenceRange(int lowerBound, int upperBound) {
        if (lowerBound > 0 || upperBound < 0) {
            throw new IllegalArgumentException("'" + lowerBound + ", " + upperBound + "' ConfidenceRange must have non-positive lowerBound and non-negative upperBound!");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public int upperBound() {
        return this.upperBound;
    }

    public boolean isPrecise() {
        return this.equals(PRECISE);
    }

    public boolean isImprecise() {
        return !this.isPrecise();
    }

    public int length() {
        return -this.lowerBound + this.upperBound;
    }

    @Override
    public int compareTo(ConfidenceRange o) {
        return ConfidenceRange.compare(this, o);
    }

    public static int compare(ConfidenceRange x, ConfidenceRange y) {
        return Integer.compare(y.length(), x.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfidenceRange that = (ConfidenceRange)o;
        return this.lowerBound == that.lowerBound && this.upperBound == that.upperBound;
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public String toString() {
        return this.isPrecise() ? "" : "(-" + -this.lowerBound + ", +" + this.upperBound + ")";
    }
}

