/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.formats.hpo.AnnotatedItem;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseDefault;
import org.monarchinitiative.phenol.annotations.formats.hpo.Utils;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public interface HpoDisease
extends AnnotatedItem {
    public static HpoDisease of(TermId diseaseId, String diseaseName, TemporalInterval globalOnset, List<HpoDiseaseAnnotation> phenotypicAbnormalities, List<TermId> modesOfInheritance) {
        return new HpoDiseaseDefault(diseaseId, diseaseName, globalOnset, phenotypicAbnormalities, modesOfInheritance);
    }

    public String diseaseName();

    public Collection<HpoDiseaseAnnotation> annotations();

    @Deprecated(forRemoval=true, since="2.0.0-RC5")
    default public int annotationCount() {
        return this.annotations().size();
    }

    public List<TermId> modesOfInheritance();

    default public Iterable<HpoDiseaseAnnotation> presentAnnotations() {
        return Utils.filterIterable(this.annotations(), HpoDiseaseAnnotation::isPresent);
    }

    default public Iterable<HpoDiseaseAnnotation> absentAnnotations() {
        return Utils.filterIterable(this.annotations(), HpoDiseaseAnnotation::isAbsent);
    }

    default public Stream<HpoDiseaseAnnotation> annotationStream() {
        return StreamSupport.stream(this.annotations().spliterator(), false);
    }

    default public Stream<HpoDiseaseAnnotation> presentAnnotationsStream() {
        return this.annotationStream().filter(HpoDiseaseAnnotation::isPresent);
    }

    default public Stream<HpoDiseaseAnnotation> absentAnnotationsStream() {
        return this.annotationStream().filter(HpoDiseaseAnnotation::isAbsent);
    }

    default public Optional<TemporalInterval> diseaseOnset() {
        PointInTime start = null;
        PointInTime end = null;
        for (HpoDiseaseAnnotation annotation : this.presentAnnotations()) {
            Optional<PointInTime> onset = annotation.earliestOnset();
            if (!onset.isPresent()) continue;
            start = start == null ? onset.get() : PointInTime.min(onset.get(), start);
            end = end == null ? onset.get() : PointInTime.max(onset.get(), end);
        }
        return start != null && end != null ? Optional.of(TemporalInterval.of(start, end)) : Optional.empty();
    }

    default public Optional<HpoDiseaseAnnotation> getAnnotation(TermId termId) {
        return this.annotationStream().filter(diseaseAnnotation -> diseaseAnnotation.id().equals((Object)termId)).findAny();
    }

    default public Optional<Ratio> getFrequencyOfTermInDisease(TermId termId) {
        return this.getAnnotation(termId).map(HpoDiseaseAnnotation::ratio);
    }

    default public Stream<TermId> annotationTermIds() {
        return this.annotationStream().map(Identified::id);
    }

    default public List<TermId> annotationTermIdList() {
        return this.annotationTermIds().collect(Collectors.toList());
    }

    default public boolean isAnnotatedTo(TermId termId, MinimalOntology hpo) {
        return this.presentAnnotationsStream().flatMap(a -> hpo.graph().getAncestorsStream((Object)a.id(), true)).anyMatch(arg_0 -> ((TermId)termId).equals(arg_0));
    }

    default public boolean isDirectlyAnnotatedTo(TermId termId) {
        return this.presentAnnotationsStream().anyMatch(annotation -> annotation.id().equals((Object)termId));
    }

    default public boolean isDirectlyAnnotatedToAnyOf(Set<TermId> termIds) {
        return this.presentAnnotationsStream().anyMatch(annotation -> termIds.contains(annotation.id()));
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId diseaseDatabaseTermId() {
        return this.id();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public TermId getDiseaseDatabaseTermId() {
        return this.id();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getName() {
        return this.diseaseName();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public String getDiseaseName() {
        return this.diseaseName();
    }

    @Deprecated(forRemoval=true, since="2.0.0-RC2")
    default public List<TermId> getModesOfInheritance() {
        return this.modesOfInheritance();
    }

    @Deprecated(forRemoval=true)
    default public Iterator<HpoDiseaseAnnotation> phenotypicAbnormalities() {
        return this.annotations().iterator();
    }

    @Deprecated(forRemoval=true)
    default public int phenotypicAbnormalitiesCount() {
        return this.annotationCount();
    }

    @Deprecated(forRemoval=true)
    default public Stream<HpoDiseaseAnnotation> phenotypicAbnormalitiesStream() {
        return StreamSupport.stream(Spliterators.spliterator(this.phenotypicAbnormalities(), (long)this.phenotypicAbnormalitiesCount(), 0), false);
    }

    @Deprecated(forRemoval=true, since="2.0.0-RC2")
    default public List<HpoAnnotationLine> getPhenotypicAbnormalities() {
        throw new PhenolRuntimeException("The 'getPhenotypicAbnormalities()` method was deprecated. Use `phenotypicAbnormalities()` instead!");
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> negativeAnnotations() {
        return this.absentAnnotationsStream().map(Identified::id).collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getNegativeAnnotations() {
        return this.negativeAnnotations();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public List<TermId> getPhenotypicAbnormalityTermIdList() {
        return this.getPhenotypicAbnormalityTermIds().collect(Collectors.toList());
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public Stream<TermId> getPhenotypicAbnormalityTermIds() {
        return this.annotationTermIds();
    }

    @Deprecated(since="2.0.0-RC2", forRemoval=true)
    default public long getNumberOfPhenotypeAnnotations() {
        return this.annotationCount();
    }
}

