/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoFrequency implements Identified,
Ratio
{
    OBLIGATE(HpoFrequencyTermIds.OBLIGATE, "Obligate", 50),
    VERY_FREQUENT(HpoFrequencyTermIds.VERY_FREQUENT, "Very frequent", 45),
    FREQUENT(HpoFrequencyTermIds.FREQUENT, "Frequent", 27),
    OCCASIONAL(HpoFrequencyTermIds.OCCASIONAL, "Occasional", 9),
    VERY_RARE(HpoFrequencyTermIds.VERY_RARE, "Very rare", 1),
    EXCLUDED(HpoFrequencyTermIds.EXCLUDED, "Excluded", 0);

    private final TermId termId;
    private final String label;
    private final int numerator;

    private HpoFrequency(TermId termId, String label, int numerator) {
        this.termId = termId;
        this.label = label;
        this.numerator = numerator;
    }

    @Deprecated
    public TermId termId() {
        return this.termId;
    }

    public TermId id() {
        return this.termId;
    }

    public String label() {
        return this.label;
    }

    @Override
    public int numerator() {
        return this.numerator;
    }

    @Override
    public int denominator() {
        return 50;
    }

    @Override
    public float frequency() {
        switch (this) {
            case EXCLUDED: {
                return 0.0f;
            }
            case VERY_RARE: {
                return 0.024999999f;
            }
            case OCCASIONAL: {
                return 0.17f;
            }
            case FREQUENT: {
                return 0.545f;
            }
            case VERY_FREQUENT: {
                return 0.895f;
            }
        }
        return 1.0f;
    }

    @Deprecated
    public float mean() {
        return this.frequency();
    }

    public static HpoFrequency fromTermId(TermId termId) throws IllegalArgumentException {
        switch (termId.getValue()) {
            case "HP:0040280": {
                return OBLIGATE;
            }
            case "HP:0040281": {
                return VERY_FREQUENT;
            }
            case "HP:0040282": {
                return FREQUENT;
            }
            case "HP:0040283": {
                return OCCASIONAL;
            }
            case "HP:0040284": {
                return VERY_RARE;
            }
            case "HP:0040285": {
                return EXCLUDED;
            }
        }
        throw new IllegalArgumentException("TermId " + String.valueOf(termId) + " is not a valid frequency sub ontology term ID");
    }

    public String toString() {
        return this.label + " (" + String.valueOf(this.termId) + ")";
    }
}

