/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.formats.hpo;

import java.util.List;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.base.temporal.Age;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoOnsetTermIds;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoOnset implements Identified,
TemporalInterval
{
    ANTENATAL_ONSET(HpoOnsetTermIds.ANTENATAL_ONSET, PointInTime.lastMenstrualPeriod(), PointInTime.birth()),
    EMBRYONAL_ONSET(HpoOnsetTermIds.EMBRYONAL_ONSET, PointInTime.lastMenstrualPeriod(), Age.gestational(11, 0)),
    FETAL_ONSET(HpoOnsetTermIds.FETAL_ONSET, Age.gestational(11, 0), PointInTime.birth()),
    LATE_FIRST_TRIMESTER_ONSET(HpoOnsetTermIds.LATE_FIRST_TRIMESTER_ONSET, Age.gestational(11, 0), Age.gestational(14, 0)),
    SECOND_TRIMESTER_ONSET(HpoOnsetTermIds.SECOND_TRIMESTER_ONSET, Age.gestational(14, 0), Age.gestational(28, 0)),
    THIRD_TRIMESTER_ONSET(HpoOnsetTermIds.THIRD_TRIMESTER_ONSET, Age.gestational(28, 0), PointInTime.birth()),
    CONGENITAL_ONSET(HpoOnsetTermIds.CONGENITAL_ONSET, PointInTime.birth(), PointInTime.birth()),
    NEONATAL_ONSET(HpoOnsetTermIds.NEONATAL_ONSET, PointInTime.birth(), Age.postnatal(29)),
    PEDIATRIC_ONSET(HpoOnsetTermIds.PEDIATRIC_ONSET, Age.postnatal(29), Age.postnatal(16, 0, 0)),
    INFANTILE_ONSET(HpoOnsetTermIds.INFANTILE_ONSET, Age.postnatal(29), Age.postnatal(1, 0, 0)),
    CHILDHOOD_ONSET(HpoOnsetTermIds.CHILDHOOD_ONSET, Age.postnatal(1, 0, 0), Age.postnatal(5, 0, 0)),
    JUVENILE_ONSET(HpoOnsetTermIds.JUVENILE_ONSET, Age.postnatal(5, 0, 0), Age.postnatal(16, 0, 0)),
    ADULT_ONSET(HpoOnsetTermIds.ADULT_ONSET, Age.postnatal(16, 0, 0), Age.openEnd()),
    YOUNG_ADULT_ONSET(HpoOnsetTermIds.YOUNG_ADULT_ONSET, Age.postnatal(16, 0, 0), Age.postnatal(40, 0, 0)),
    EARLY_YOUNG_ADULT_ONSET(HpoOnsetTermIds.EARLY_YOUNG_ADULT_ONSET, Age.postnatal(16, 0, 0), Age.postnatal(19, 0, 0)),
    INTERMEDIATE_YOUNG_ADULT_ONSET(HpoOnsetTermIds.INTERMEDIATE_YOUNG_ADULT_ONSET, Age.postnatal(19, 0, 0), Age.postnatal(25, 0, 0)),
    LATE_YOUNG_ADULT_ONSET(HpoOnsetTermIds.LATE_YOUNG_ADULT_ONSET, Age.postnatal(25, 0, 0), Age.postnatal(40, 0, 0)),
    MIDDLE_AGE_ONSET(HpoOnsetTermIds.MIDDLE_AGE_ONSET, Age.postnatal(40, 0, 0), Age.postnatal(60, 0, 0)),
    LATE_ONSET(HpoOnsetTermIds.LATE_ONSET, Age.postnatal(60, 0, 0), Age.openEnd());

    private final TermId id;
    private final PointInTime start;
    private final PointInTime end;

    private HpoOnset(TermId id, PointInTime start, PointInTime end) {
        this.id = id;
        this.start = start;
        this.end = end;
    }

    public TermId id() {
        return this.id;
    }

    @Override
    public PointInTime start() {
        return this.start;
    }

    @Override
    public PointInTime end() {
        return this.end;
    }

    public static Optional<HpoOnset> fromTermId(TermId termId) {
        return HpoOnset.fromHpoIdString(termId.getValue());
    }

    public static Optional<HpoOnset> fromHpoIdString(String termId) {
        switch (termId) {
            case "HP:0030674": {
                return Optional.of(ANTENATAL_ONSET);
            }
            case "HP:0011460": {
                return Optional.of(EMBRYONAL_ONSET);
            }
            case "HP:0011461": {
                return Optional.of(FETAL_ONSET);
            }
            case "HP:0034199": {
                return Optional.of(LATE_FIRST_TRIMESTER_ONSET);
            }
            case "HP:0034198": {
                return Optional.of(SECOND_TRIMESTER_ONSET);
            }
            case "HP:0034197": {
                return Optional.of(THIRD_TRIMESTER_ONSET);
            }
            case "HP:0003577": {
                return Optional.of(CONGENITAL_ONSET);
            }
            case "HP:0003623": {
                return Optional.of(NEONATAL_ONSET);
            }
            case "HP:0410280": {
                return Optional.of(PEDIATRIC_ONSET);
            }
            case "HP:0003593": {
                return Optional.of(INFANTILE_ONSET);
            }
            case "HP:0011463": {
                return Optional.of(CHILDHOOD_ONSET);
            }
            case "HP:0003621": {
                return Optional.of(JUVENILE_ONSET);
            }
            case "HP:0003581": {
                return Optional.of(ADULT_ONSET);
            }
            case "HP:0011462": {
                return Optional.of(YOUNG_ADULT_ONSET);
            }
            case "HP:0025708": {
                return Optional.of(EARLY_YOUNG_ADULT_ONSET);
            }
            case "HP:0025709": {
                return Optional.of(INTERMEDIATE_YOUNG_ADULT_ONSET);
            }
            case "HP:0025710": {
                return Optional.of(LATE_YOUNG_ADULT_ONSET);
            }
            case "HP:0003596": {
                return Optional.of(MIDDLE_AGE_ONSET);
            }
            case "HP:0003584": {
                return Optional.of(LATE_ONSET);
            }
        }
        return Optional.empty();
    }

    public static Optional<HpoOnset> fromAge(Age age) {
        for (HpoOnset onset : HpoOnset.specificOnsets()) {
            if (!onset.contains(age)) continue;
            return Optional.of(onset);
        }
        return Optional.empty();
    }

    public static List<HpoOnset> specificOnsets() {
        return List.of(EMBRYONAL_ONSET, LATE_FIRST_TRIMESTER_ONSET, SECOND_TRIMESTER_ONSET, THIRD_TRIMESTER_ONSET, CONGENITAL_ONSET, NEONATAL_ONSET, INFANTILE_ONSET, CHILDHOOD_ONSET, JUVENILE_ONSET, EARLY_YOUNG_ADULT_ONSET, INTERMEDIATE_YOUNG_ADULT_ONSET, LATE_YOUNG_ADULT_ONSET, MIDDLE_AGE_ONSET, LATE_ONSET);
    }

    @Deprecated(forRemoval=true)
    public boolean available() {
        return true;
    }

    @Deprecated(forRemoval=true, since="2.0.0-RC3")
    public TermId toTermId() {
        return this.id();
    }
}

