/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.Sex;
import org.monarchinitiative.phenol.annotations.formats.AnnotationReference;
import org.monarchinitiative.phenol.annotations.formats.EvidenceCode;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.annotations.io.hpo.Aspect;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.ontology.data.Identified;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAnnotationLine
implements Identified {
    private final TermId diseaseId;
    private final String diseaseName;
    private final boolean isNegated;
    private final TermId phenotypeTermId;
    private final List<AnnotationReference> annotationReferences;
    private final HpoOnset onset;
    private final String frequency;
    private final Sex sex;
    private final List<TermId> modifiers;
    private final Aspect aspect;
    private final List<String> curators;

    public static HpoAnnotationLine of(TermId diseaseId, String diseaseName, boolean isNegated, TermId phenotypeTermId, List<AnnotationReference> annotationReferences, HpoOnset onset, String frequency, Sex sex, List<TermId> modifiers, Aspect aspect, List<String> curators) {
        return new HpoAnnotationLine(diseaseId, diseaseName, isNegated, phenotypeTermId, annotationReferences, onset, frequency, sex, modifiers, aspect, curators);
    }

    public static HpoAnnotationLine of(String line) throws PhenolException {
        try {
            String[] fields = line.split("\t");
            TermId diseaseId = TermId.of((String)fields[0]);
            String diseaseName = fields[1];
            boolean isNegated = fields[2].equalsIgnoreCase("NOT");
            TermId phenotype = TermId.of((String)fields[3]);
            EvidenceCode code = EvidenceCode.parse(fields[5]);
            List<AnnotationReference> annotationReferences = Arrays.stream(fields[4].split(";")).filter(token -> !token.isBlank()).map(reference -> AnnotationReference.of(TermId.of((String)reference), code)).collect(Collectors.toList());
            HpoOnset onsetId = HpoOnset.fromHpoIdString(fields[6]).orElse(null);
            String frequency = fields[7];
            Sex sex = Sex.parse(fields[8]).orElse(null);
            List<TermId> modifiers = Arrays.stream(fields[9].split(";")).filter(token -> !token.isBlank()).map(TermId::of).collect(Collectors.toList());
            Aspect aspect = Aspect.parse(fields[10]).orElse(null);
            List<String> curators = Arrays.stream(fields[11].split(";")).map(String::trim).collect(Collectors.toList());
            return HpoAnnotationLine.of(diseaseId, diseaseName, isNegated, phenotype, annotationReferences, onsetId, frequency, sex, modifiers, aspect, curators);
        }
        catch (PhenolRuntimeException e) {
            throw new PhenolException(String.format("Exception [%s] parsing line: %s", e.getMessage(), line));
        }
    }

    private HpoAnnotationLine(TermId diseaseId, String diseaseName, boolean isNegated, TermId phenotypeTermId, List<AnnotationReference> annotationReferences, HpoOnset onset, String frequency, Sex sex, List<TermId> modifiers, Aspect aspect, List<String> curators) {
        this.diseaseId = Objects.requireNonNull(diseaseId);
        this.diseaseName = Objects.requireNonNull(diseaseName);
        this.isNegated = isNegated;
        this.phenotypeTermId = Objects.requireNonNull(phenotypeTermId, "Term ID must not be null");
        this.frequency = Objects.requireNonNull(frequency, "Annotation frequency must not be null");
        this.onset = onset;
        this.modifiers = Objects.requireNonNull(modifiers, "Modifiers must not be null");
        this.annotationReferences = Objects.requireNonNull(annotationReferences);
        this.sex = sex;
        this.aspect = Objects.requireNonNull(aspect);
        this.curators = Objects.requireNonNull(curators);
    }

    public TermId id() {
        return this.phenotypeTermId();
    }

    public TermId diseaseId() {
        return this.diseaseId;
    }

    public String diseaseName() {
        return this.diseaseName;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public TermId phenotypeTermId() {
        return this.phenotypeTermId;
    }

    public String frequency() {
        return this.frequency;
    }

    public Optional<HpoOnset> onset() {
        return Optional.ofNullable(this.onset);
    }

    public List<TermId> modifiers() {
        return this.modifiers;
    }

    public List<AnnotationReference> annotationReferences() {
        return this.annotationReferences;
    }

    public Sex sex() {
        return this.sex;
    }

    public Aspect aspect() {
        return this.aspect;
    }

    public List<String> curators() {
        return this.curators;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HpoAnnotationLine that = (HpoAnnotationLine)o;
        return this.isNegated == that.isNegated && Objects.equals(this.diseaseId, that.diseaseId) && Objects.equals(this.diseaseName, that.diseaseName) && Objects.equals(this.phenotypeTermId, that.phenotypeTermId) && Objects.equals(this.annotationReferences, that.annotationReferences) && this.onset == that.onset && Objects.equals(this.frequency, that.frequency) && this.sex == that.sex && Objects.equals(this.modifiers, that.modifiers) && this.aspect == that.aspect && Objects.equals(this.curators, that.curators);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diseaseId, this.diseaseName, this.isNegated, this.phenotypeTermId, this.annotationReferences, this.onset, this.frequency, this.sex, this.modifiers, this.aspect, this.curators});
    }

    public String toString() {
        return "HpoAnnotationLine{diseaseId=" + String.valueOf(this.diseaseId) + ", diseaseName='" + this.diseaseName + "', isNegated=" + this.isNegated + ", phenotypeTermId=" + String.valueOf(this.phenotypeTermId) + ", annotationReferences=" + String.valueOf(this.annotationReferences) + ", onset=" + String.valueOf(this.onset) + ", frequency='" + this.frequency + "', sex=" + String.valueOf((Object)this.sex) + ", modifiers=" + String.valueOf(this.modifiers) + ", aspect=" + String.valueOf((Object)this.aspect) + ", curators=" + String.valueOf(this.curators) + "}";
    }
}

