/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.annotations.base.Ratio;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoClinicalModifierTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotation;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseaseAnnotationRecord;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoDiseases;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoFrequency;
import org.monarchinitiative.phenol.annotations.formats.hpo.HpoOnset;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoader;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoDiseaseLoaderOptions;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseData;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataContainer;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataLoader;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.TermId;

class HpoDiseaseLoaderDefault
implements HpoDiseaseLoader {
    private static final Pattern HPO_PATTERN = Pattern.compile("HP:\\d{7}");
    private static final Pattern RATIO_PATTERN = Pattern.compile("(?<numerator>\\d+)/(?<denominator>\\d+)");
    private static final Pattern PERCENTAGE_PATTERN = Pattern.compile("(?<value>\\d+\\.?(\\d+)?)%");
    private final HpoaDiseaseDataLoader loader;
    private final int cohortSize;
    private final boolean salvageNegatedFrequencies;
    protected final Set<DiseaseDatabase> databasePrefixes;
    protected final Set<TermId> clinicalCourseSubHierarchy;
    protected final Set<TermId> inheritanceSubHierarchy;

    HpoDiseaseLoaderDefault(MinimalOntology hpo, HpoDiseaseLoaderOptions options) {
        Objects.requireNonNull(hpo, "HPO ontology must not be null.");
        Objects.requireNonNull(options, "Options must not be null.");
        this.cohortSize = options.cohortSize();
        this.salvageNegatedFrequencies = options.salvageNegatedFrequencies();
        this.databasePrefixes = options.includedDatabases();
        this.loader = HpoaDiseaseDataLoader.of(this.databasePrefixes);
        this.clinicalCourseSubHierarchy = hpo.termForTermId(HpoClinicalModifierTermIds.CLINICAL_COURSE).isPresent() ? hpo.graph().getDescendantsStream((Object)HpoClinicalModifierTermIds.CLINICAL_COURSE, true).collect(Collectors.toSet()) : Set.of();
        this.inheritanceSubHierarchy = hpo.termForTermId(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT).isPresent() ? hpo.graph().getDescendantsStream((Object)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT, true).collect(Collectors.toSet()) : Set.of();
    }

    @Override
    public HpoDiseases load(InputStream is) throws IOException {
        HpoaDiseaseDataContainer container = this.loader.loadDiseaseData(is);
        List<HpoDisease> diseases = container.stream().map(this::assembleIntoDisease).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        return HpoDiseases.of(container.version().orElse(null), diseases);
    }

    private static TemporalInterval calculateGlobalOnset(Iterable<TermId> clinicalCourseTerms, Iterable<HpoDiseaseAnnotation> annotations) {
        Optional<Object> onset;
        PointInTime start = null;
        PointInTime end = null;
        for (TermId clinicalCourse : clinicalCourseTerms) {
            onset = HpoOnset.fromTermId(clinicalCourse);
            if (!onset.isPresent()) continue;
            HpoOnset current = onset.get();
            start = start == null ? current.start() : PointInTime.min(current.start(), start);
            end = end == null ? current.end() : PointInTime.max(current.end(), end);
        }
        if (start != null && end != null) {
            return TemporalInterval.of(start, end);
        }
        for (HpoDiseaseAnnotation annotation : annotations) {
            if (!annotation.isPresent() || !(onset = annotation.earliestOnset()).isPresent()) continue;
            start = start == null ? (PointInTime)onset.get() : PointInTime.min((PointInTime)onset.get(), start);
            end = end == null ? (PointInTime)onset.get() : PointInTime.max((PointInTime)onset.get(), end);
        }
        return start == null || end == null ? null : TemporalInterval.of(start, end);
    }

    private Ratio parseFrequency(boolean isNegated, String frequency) throws IllegalArgumentException {
        Matcher matcher;
        boolean notDone = true;
        int numerator = -1;
        int denominator = -1;
        if (frequency == null || "".equals(frequency)) {
            numerator = isNegated ? 0 : 1;
            denominator = 1;
            return Ratio.of(numerator, denominator);
        }
        if (HPO_PATTERN.matcher(frequency).matches()) {
            HpoFrequency hpoFrequency = HpoFrequency.fromTermId(TermId.of((String)frequency));
            numerator = isNegated ? 0 : Math.round(hpoFrequency.frequency() * (float)this.cohortSize);
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone && (matcher = RATIO_PATTERN.matcher(frequency)).matches()) {
            denominator = Integer.parseInt(matcher.group("denominator"));
            int i = Integer.parseInt(matcher.group("numerator"));
            if (isNegated) {
                if (denominator == 0) {
                    denominator = this.cohortSize;
                }
                numerator = i == 0 && this.salvageNegatedFrequencies ? 0 : denominator - i;
            } else {
                numerator = i;
            }
            notDone = false;
        }
        if (notDone && (matcher = PERCENTAGE_PATTERN.matcher(frequency)).matches()) {
            float percentage = Float.parseFloat(matcher.group("value"));
            numerator = Math.round(percentage * (float)this.cohortSize / 100.0f);
            denominator = this.cohortSize;
            notDone = false;
        }
        if (notDone) {
            throw new IllegalArgumentException();
        }
        return Ratio.of(numerator, denominator);
    }

    private PartitionedHpoDiseaseLines partitionDiseaseAnnotationLines(Iterable<HpoAnnotationLine> annotationLines) {
        LinkedList<HpoAnnotationLine> phenotypes = new LinkedList<HpoAnnotationLine>();
        LinkedList<TermId> modesOfInheritance = new LinkedList<TermId>();
        LinkedList<TermId> clinicalModifierListBuilder = new LinkedList<TermId>();
        LinkedList<TermId> clinicalCourse = new LinkedList<TermId>();
        String diseaseName = null;
        for (HpoAnnotationLine line : annotationLines) {
            TermId phenotypeId;
            if (diseaseName == null) {
                diseaseName = line.diseaseName();
            }
            if (this.inheritanceSubHierarchy.contains(phenotypeId = line.phenotypeTermId())) {
                modesOfInheritance.add(phenotypeId);
                continue;
            }
            if (this.clinicalCourseSubHierarchy.contains(phenotypeId)) {
                clinicalCourse.add(phenotypeId);
                continue;
            }
            if (phenotypeId.equals((Object)HpoSubOntologyRootTermIds.CLINICAL_MODIFIER)) {
                clinicalModifierListBuilder.add(phenotypeId);
                continue;
            }
            phenotypes.add(line);
        }
        return new PartitionedHpoDiseaseLines(diseaseName, phenotypes, modesOfInheritance, clinicalModifierListBuilder, clinicalCourse);
    }

    private Optional<? extends HpoDisease> assembleIntoDisease(HpoaDiseaseData diseaseData) {
        PartitionedHpoDiseaseLines partitioned = this.partitionDiseaseAnnotationLines(diseaseData.annotationLines());
        Map<TermId, List<HpoAnnotationLine>> phenotypeById = partitioned.phenotypes.stream().collect(Collectors.groupingBy(HpoAnnotationLine::phenotypeTermId));
        List<HpoDiseaseAnnotation> annotations = phenotypeById.entrySet().stream().map(entry -> this.toDiseaseAnnotation((TermId)entry.getKey(), (Iterable)entry.getValue())).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
        TemporalInterval globalOnset = HpoDiseaseLoaderDefault.calculateGlobalOnset(partitioned.clinicalCourseTerms, annotations);
        return Optional.of(HpoDisease.of(diseaseData.id(), partitioned.diseaseName, globalOnset, annotations, partitioned.modesOfInheritance));
    }

    private Optional<HpoDiseaseAnnotation> toDiseaseAnnotation(TermId phenotypeFeature, Iterable<HpoAnnotationLine> annotationLines) {
        ArrayList<HpoDiseaseAnnotationRecord> records = new ArrayList<HpoDiseaseAnnotationRecord>();
        for (HpoAnnotationLine line : annotationLines) {
            Ratio ratio = this.parseFrequency(line.isNegated(), line.frequency());
            TemporalInterval onset = line.onset().map(interval -> TemporalInterval.openEnd(interval.start())).orElse(null);
            records.add(HpoDiseaseAnnotationRecord.of(ratio, onset, List.copyOf(line.annotationReferences()), line.sex(), List.copyOf(line.modifiers())));
        }
        return Optional.of(HpoDiseaseAnnotation.of(phenotypeFeature, records));
    }

    private static class PartitionedHpoDiseaseLines {
        private final String diseaseName;
        private final List<HpoAnnotationLine> phenotypes;
        private final List<TermId> modesOfInheritance;
        private final List<TermId> clinicalModifiers;
        private final List<TermId> clinicalCourseTerms;

        private PartitionedHpoDiseaseLines(String diseaseName, List<HpoAnnotationLine> phenotypes, List<TermId> modesOfInheritance, List<TermId> clinicalModifiers, List<TermId> clinicalCourseTerms) {
            this.diseaseName = diseaseName;
            this.phenotypes = phenotypes;
            this.modesOfInheritance = modesOfInheritance;
            this.clinicalModifiers = clinicalModifiers;
            this.clinicalCourseTerms = clinicalCourseTerms;
        }
    }
}

