/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.monarchinitiative.phenol.annotations.io.hpo.DiseaseDatabase;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataContainer;
import org.monarchinitiative.phenol.annotations.io.hpo.HpoaDiseaseDataLoaderDefault;

public interface HpoaDiseaseDataLoader {
    public static HpoaDiseaseDataLoader of(Set<DiseaseDatabase> databasePrefixes) {
        return new HpoaDiseaseDataLoaderDefault(databasePrefixes);
    }

    public HpoaDiseaseDataContainer loadDiseaseData(InputStream var1) throws IOException;

    default public HpoaDiseaseDataContainer loadDiseaseData(Path path) throws IOException {
        try (BufferedInputStream is = HpoaDiseaseDataLoader.openForReading(path);){
            HpoaDiseaseDataContainer hpoaDiseaseDataContainer = this.loadDiseaseData(is);
            return hpoaDiseaseDataContainer;
        }
    }

    private static BufferedInputStream openForReading(Path path) throws IOException {
        InputStream is = Files.newInputStream(path, new OpenOption[0]);
        if (path.toFile().getName().endsWith("gz")) {
            is = new GZIPInputStream(is);
        }
        return new BufferedInputStream(is);
    }
}

