/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.base.temporal;

import java.util.Objects;
import org.monarchinitiative.phenol.annotations.base.temporal.Ages;
import org.monarchinitiative.phenol.annotations.base.temporal.ConfidenceRange;
import org.monarchinitiative.phenol.annotations.base.temporal.PointInTime;
import org.monarchinitiative.phenol.annotations.base.temporal.TemporalInterval;
import org.monarchinitiative.phenol.annotations.base.temporal.Util;

public interface Age
extends PointInTime,
TemporalInterval {
    public static final float DAYS_IN_JULIAN_YEAR = 365.25f;
    public static final float DAYS_IN_MONTH = 30.4375f;

    public static Age lastMenstrualPeriod() {
        return Ages.LMP;
    }

    public static Age birth() {
        return Ages.BIRTH;
    }

    public static Age gestational(int weeks, int days) {
        return Age.gestational(weeks, days, ConfidenceRange.precise());
    }

    public static Age gestational(int weeks, int days, ConfidenceRange cr) throws IllegalArgumentException {
        if (weeks < 0 || days < 0) {
            throw new IllegalArgumentException("'" + weeks + ", " + days + "' Weeks and days must be non-negative!");
        }
        return Age.of(days += weeks * 7, true, cr);
    }

    public static Age postnatal(int years, int months, int days) {
        return Age.postnatal(years, months, days, ConfidenceRange.precise());
    }

    public static Age postnatal(int years, int months, int days, ConfidenceRange cr) throws IllegalArgumentException {
        if (years < 0 || months < 0 || days < 0) {
            throw new IllegalArgumentException("'" + years + ", " + months + ", " + days + "' Years, months and days must be non-negative!");
        }
        return Age.postnatal(days + Age.convertYearsAndMonthsToDays(years, months), cr);
    }

    private static int convertYearsAndMonthsToDays(int years, int months) {
        return Math.toIntExact((long)Math.ceil((float)years * 365.25f + (float)months * 30.4375f));
    }

    public static Age postnatal(int days) {
        return Age.of(days, false, ConfidenceRange.precise());
    }

    public static Age postnatal(int days, ConfidenceRange cr) {
        return Age.of(days, false, cr);
    }

    public static Age of(int days, boolean isGestational, ConfidenceRange cr) throws IllegalArgumentException {
        Util.checkDays(days);
        if (Objects.requireNonNull(cr).isImprecise()) {
            cr = Age.clipConfidenceInterval(cr, days);
        }
        return isGestational ? Ages.gestational(days, cr) : Ages.postnatal(days, cr);
    }

    public static Age openStart() {
        return Ages.START;
    }

    public static Age openEnd() {
        return Ages.END;
    }

    public ConfidenceRange confidenceRange();

    default public boolean isPrecise() {
        return this.confidenceRange().isPrecise();
    }

    default public boolean isImprecise() {
        return !this.isPrecise();
    }

    default public int lowerBound() {
        int days = this.days();
        return this.isPrecise() ? days : days + this.confidenceRange().lowerBound();
    }

    default public int upperBound() {
        int days = this.days();
        return this.isPrecise() ? days : days + this.confidenceRange().upperBound();
    }

    default public Age plus(Age other) {
        int days = this.days() + other.days();
        return Age.of(days, this.isGestational(), this.confidenceRange());
    }

    public static Age max(Age a, Age b) {
        int compare = Age.compare(a, b);
        return compare >= 0 ? a : b;
    }

    public static Age min(Age a, Age b) {
        int compare = Age.compare(a, b);
        return compare <= 0 ? a : b;
    }

    public static int compare(Age x, Age y) {
        int result = PointInTime.compare(x, y);
        if (result != 0) {
            return result;
        }
        return ConfidenceRange.compare(x.confidenceRange(), y.confidenceRange());
    }

    private static ConfidenceRange clipConfidenceInterval(ConfidenceRange cr, int days) {
        if (cr.lowerBound() < -days) {
            return ConfidenceRange.of(-days, cr.upperBound());
        }
        return cr;
    }
}

