/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoClinicalModifierTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.annotations.constants.hpo.HpoSubOntologyRootTermIds;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum Aspect {
    P(HpoSubOntologyRootTermIds.PHENOTYPIC_ABNORMALITY),
    I(HpoModeOfInheritanceTermIds.INHERITANCE_ROOT),
    C(HpoClinicalModifierTermIds.CLINICAL_COURSE),
    M(HpoSubOntologyRootTermIds.CLINICAL_MODIFIER),
    H(HpoSubOntologyRootTermIds.PAST_MEDICAL_HISTORY);

    private final TermId termId;
    private static final Map<TermId, Aspect> BY_TERMID;

    private Aspect(TermId termId) {
        this.termId = termId;
    }

    public static Optional<Aspect> parse(String aspect) {
        switch (aspect.toUpperCase()) {
            case "P": {
                return Optional.of(P);
            }
            case "I": {
                return Optional.of(I);
            }
            case "C": {
                return Optional.of(C);
            }
            case "M": {
                return Optional.of(M);
            }
            case "H": {
                return Optional.of(H);
            }
        }
        return Optional.empty();
    }

    public static Optional<Aspect> fromTermId(TermId termId) {
        return Optional.ofNullable(BY_TERMID.get(termId));
    }

    static {
        BY_TERMID = new HashMap<TermId, Aspect>();
        for (Aspect e : Aspect.values()) {
            BY_TERMID.put(e.termId, e);
        }
    }
}

