/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.io.hpo;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;

public enum DiseaseDatabase {
    OMIM("OMIM"),
    ORPHANET("ORPHA"),
    DECIPHER("DECIPHER"),
    UNKNOWN("UNKNOWN");

    private final String prefix;

    private DiseaseDatabase(String prefix) {
        this.prefix = prefix;
    }

    public String prefix() {
        return this.prefix;
    }

    public static DiseaseDatabase fromString(String s) {
        switch (s.toUpperCase(Locale.ROOT)) {
            case "OMIM": {
                return OMIM;
            }
            case "ORPHA": 
            case "ORPHANET": {
                return ORPHANET;
            }
            case "DECIPHER": {
                return DECIPHER;
            }
        }
        return UNKNOWN;
    }

    public static Set<DiseaseDatabase> allKnownDiseaseDatabases() {
        return EnumSet.of(OMIM, ORPHANET, DECIPHER);
    }
}

