/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obographs;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.Node;
import org.geneontology.obographs.model.meta.BasicPropertyValue;
import org.geneontology.obographs.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.model.meta.XrefPropertyValue;
import org.monarchinitiative.phenol.ontology.data.Dbxref;
import org.monarchinitiative.phenol.ontology.data.SimpleXref;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermSynonym;
import org.monarchinitiative.phenol.ontology.data.TermSynonymScope;
import org.monarchinitiative.phenol.ontology.data.TermXref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboGraphTermFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OboGraphTermFactory.class);

    public Term constructTerm(Node node, TermId termId) {
        List subsets;
        Term.Builder termBuilder = Term.builder();
        termBuilder.id(termId);
        String label = node.getLabel();
        termBuilder.name(label == null ? "" : label);
        Meta meta = node.getMeta();
        if (meta == null) {
            LOGGER.debug("No meta instance exists for node: {} {}", (Object)node.getId(), (Object)node.getLabel());
            return termBuilder.build();
        }
        DefinitionPropertyValue definitionPropertyValue = meta.getDefinition();
        String definition = this.getDefinition(definitionPropertyValue);
        termBuilder.definition(definition);
        List<SimpleXref> simpleXrefs = this.convertToXrefs(definitionPropertyValue);
        termBuilder.databaseXrefs(simpleXrefs);
        List comments = meta.getComments();
        if (comments != null) {
            termBuilder.comment(String.join((CharSequence)", ", comments));
        }
        if ((subsets = meta.getSubsets()) != null) {
            termBuilder.subsets(subsets);
        }
        List<TermSynonym> termSynonyms = this.convertToSynonyms(meta.getSynonyms());
        termBuilder.synonyms(termSynonyms);
        List<Dbxref> xrefs = this.convertToDbXrefs(meta.getXrefs());
        termBuilder.xrefs(xrefs);
        boolean isObsolete = this.isObsolete(meta);
        termBuilder.obsolete(isObsolete);
        List<TermId> altIds = this.convertToAltIds(meta.getBasicPropertyValues());
        termBuilder.altTermIds(altIds);
        return termBuilder.build();
    }

    private String getDefinition(DefinitionPropertyValue definitionPropertyValue) {
        return definitionPropertyValue == null ? "" : definitionPropertyValue.getVal();
    }

    private List<SimpleXref> convertToXrefs(DefinitionPropertyValue definitionPropertyValue) {
        if (definitionPropertyValue == null) {
            return ImmutableList.of();
        }
        List xrefs = definitionPropertyValue.getXrefs();
        if (xrefs == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder simpleXrefBuilder = new ImmutableList.Builder();
        for (String xref : xrefs) {
            SimpleXref sxref = new SimpleXref(xref);
            if (!sxref.isValid()) continue;
            simpleXrefBuilder.add((Object)sxref);
        }
        return simpleXrefBuilder.build();
    }

    private List<TermSynonym> convertToSynonyms(List<SynonymPropertyValue> spvs) {
        if (spvs == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder termSynonymBuilder = new ImmutableList.Builder();
        for (SynonymPropertyValue spv : spvs) {
            TermSynonymScope scope = null;
            String pred = spv.getPred();
            if (pred.equals(SynonymPropertyValue.PREDS.hasExactSynonym.toString())) {
                scope = TermSynonymScope.EXACT;
            } else if (pred.equals(SynonymPropertyValue.PREDS.hasBroadSynonym.toString())) {
                scope = TermSynonymScope.BROAD;
            } else if (pred.equals(SynonymPropertyValue.PREDS.hasNarrowSynonym.toString())) {
                scope = TermSynonymScope.NARROW;
            } else if (pred.equals(SynonymPropertyValue.PREDS.hasRelatedSynonym.toString())) {
                scope = TermSynonymScope.RELATED;
            }
            String synonymType = spv.getSynonymType();
            String synonymTypeName = String.join((CharSequence)", ", spv.getTypes());
            List xrefs = spv.getXrefs();
            List<TermXref> termXrefs = this.mapXref(xrefs);
            TermSynonym its = new TermSynonym(spv.getVal(), scope, synonymTypeName, termXrefs, synonymType);
            termSynonymBuilder.add((Object)its);
        }
        return termSynonymBuilder.build();
    }

    private List<TermXref> mapXref(List<String> xrefs) {
        ImmutableList.Builder termXrefBuilder = new ImmutableList.Builder();
        for (String xref : xrefs) {
            try {
                TermId xrefTermId = TermId.of((String)xref);
                TermXref trf = new TermXref(xrefTermId, "");
                termXrefBuilder.add((Object)trf);
            }
            catch (Exception exception) {}
        }
        return termXrefBuilder.build();
    }

    private List<Dbxref> convertToDbXrefs(List<XrefPropertyValue> xrefPropertyValues) {
        if (xrefPropertyValues == null || xrefPropertyValues.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder dbxrefs = new ImmutableList.Builder();
        for (XrefPropertyValue xrefPropertyValue : xrefPropertyValues) {
            String val = xrefPropertyValue.getVal();
            if (val == null) continue;
            dbxrefs.add((Object)new Dbxref(val, null, null));
        }
        return dbxrefs.build();
    }

    private boolean isObsolete(Meta meta) {
        try {
            Field f = Meta.class.getDeclaredField("deprecated");
            f.setAccessible(true);
            Boolean deprecated = (Boolean)f.get(meta);
            if (deprecated == null) {
                return false;
            }
            return deprecated;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    private List<TermId> convertToAltIds(List<BasicPropertyValue> basicPropertyValues) {
        if (basicPropertyValues == null || basicPropertyValues.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder altIdsBuilder = new ImmutableList.Builder();
        for (BasicPropertyValue bpv : basicPropertyValues) {
            if (!"http://www.geneontology.org/formats/oboInOwl#hasAlternativeId".equals(bpv.getPred())) continue;
            String altId = bpv.getVal();
            altIdsBuilder.add((Object)TermId.of((String)altId));
        }
        return altIdsBuilder.build();
    }
}

