/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obographs;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.geneontology.obographs.core.model.AbstractNode;
import org.geneontology.obographs.core.model.Edge;
import org.geneontology.obographs.core.model.Graph;
import org.geneontology.obographs.core.model.GraphDocument;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.Node;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.io.obographs.OboGraphTermFactory;
import org.monarchinitiative.phenol.io.utils.CurieUtilBuilder;
import org.monarchinitiative.phenol.ontology.data.ImmutableOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Relationship;
import org.monarchinitiative.phenol.ontology.data.RelationshipType;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.prefixcommons.CurieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboGraphDocumentAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OboGraphDocumentAdaptor.class);
    private final Map<String, String> metaInfo;
    private final List<Term> terms;
    private final List<Relationship> relationships;

    private OboGraphDocumentAdaptor(Builder builder) {
        this.metaInfo = builder.metaInfo;
        this.terms = builder.terms;
        this.relationships = builder.relationships;
    }

    public Map<String, String> getMetaInfo() {
        return this.metaInfo;
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    public Ontology buildOntology() {
        return ImmutableOntology.builder().metaInfo(this.metaInfo).terms(this.terms).relationships(this.relationships).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private OboGraphTermFactory factory = new OboGraphTermFactory();
        private CurieUtil curieUtil = CurieUtilBuilder.defaultCurieUtil();
        private Set<String> wantedTermIdPrefixes = Collections.emptySet();
        private Map<String, String> metaInfo;
        private List<Term> terms;
        private List<Relationship> relationships;

        public Builder curieUtil(CurieUtil curieUtil) {
            Objects.requireNonNull(curieUtil);
            this.curieUtil = curieUtil;
            return this;
        }

        public Builder wantedTermIdPrefixes(Set<String> wantedTermIdPrefixes) {
            Objects.requireNonNull(wantedTermIdPrefixes);
            this.wantedTermIdPrefixes = wantedTermIdPrefixes;
            return this;
        }

        public OboGraphDocumentAdaptor build(GraphDocument graphDocument) {
            List<String> unMappedIdPrefixes = this.getWantedButUnmappedIdPrefixes();
            if (!unMappedIdPrefixes.isEmpty()) {
                String message = String.format("Unable to filter terms for prefix(s) %s as these not mapped. Add the mapping to CurieUtil.", unMappedIdPrefixes);
                throw new PhenolRuntimeException(message);
            }
            Graph oboGraph = this.getFirstGraph(graphDocument);
            LOGGER.debug("Converting graph document...");
            LOGGER.debug("Converting metadata...");
            this.metaInfo = this.convertMetaData(oboGraph.getMeta());
            LOGGER.debug("Converting nodes to terms...");
            this.terms = this.convertNodesToTerms((List<Node>)oboGraph.getNodes());
            LOGGER.debug("Converting edges to relationships...");
            this.relationships = this.convertEdgesToRelationships((List<Edge>)oboGraph.getEdges(), (List<Node>)oboGraph.getNodes());
            return new OboGraphDocumentAdaptor(this);
        }

        private Graph getFirstGraph(GraphDocument graphDocument) {
            Objects.requireNonNull(graphDocument);
            ImmutableList graphs = graphDocument.getGraphs();
            if (graphs == null || graphs.isEmpty()) {
                throw new PhenolRuntimeException("GraphDocument is empty");
            }
            return (Graph)graphs.get(0);
        }

        private List<String> getWantedButUnmappedIdPrefixes() {
            ArrayList<String> unmappedIdPrefixes = new ArrayList<String>();
            if (!this.wantedTermIdPrefixes.isEmpty()) {
                for (String prefix : this.wantedTermIdPrefixes) {
                    if (this.curieUtil.getCurieMap().containsKey(prefix)) continue;
                    unmappedIdPrefixes.add(prefix);
                }
            }
            return unmappedIdPrefixes;
        }

        private Map<String, String> convertMetaData(Meta meta) {
            if (meta == null) {
                return Map.of();
            }
            TreeMap<String, String> metaMap = new TreeMap<String, String>();
            String version = meta.getVersion() != null ? meta.getVersion() : "";
            metaMap.put("data-version", version);
            String versionInfo = null;
            if (meta.getBasicPropertyValues() != null) {
                for (BasicPropertyValue basicPropertyValue : meta.getBasicPropertyValues()) {
                    if (basicPropertyValue.getPred().equalsIgnoreCase("date")) {
                        String date = basicPropertyValue.getVal().trim();
                        metaMap.put("date", date);
                        continue;
                    }
                    if (!basicPropertyValue.getPred().contains("#versionInfo")) continue;
                    versionInfo = basicPropertyValue.getVal();
                }
            }
            if (versionInfo != null) {
                metaMap.put("release", versionInfo);
            } else if (version != null) {
                Optional<String> releaseDate = Builder.findDate(version);
                if (releaseDate.isPresent()) {
                    metaMap.put("release", releaseDate.get());
                } else {
                    LOGGER.warn("Unable to parse release from IRI `{}`.", (Object)version);
                }
            } else {
                LOGGER.warn("Unable to retrieve release for ontology.");
            }
            return Collections.unmodifiableSortedMap(metaMap);
        }

        private static Optional<String> findDate(String payload) {
            Pattern datePattern = Pattern.compile("(?<value>20\\d{2}-\\d{2}-\\d{2})");
            Matcher matcher = datePattern.matcher(payload);
            if (!matcher.find()) {
                return Optional.empty();
            }
            String value = matcher.group("value");
            if (matcher.find()) {
                LOGGER.warn("More than one match for date in IRI `{}`", (Object)payload);
                return Optional.empty();
            }
            return Optional.of(value);
        }

        private List<Term> convertNodesToTerms(List<Node> nodes) {
            ArrayList<Term> termsList = new ArrayList<Term>();
            if (nodes == null || nodes.isEmpty()) {
                LOGGER.warn("No nodes found in loaded ontology.");
                throw new PhenolRuntimeException("PhenolException: No nodes found in loaded ontology.");
            }
            for (Node node : nodes) {
                TermId termId;
                if (node.getType() == null || node.getType() != AbstractNode.RDFTYPES.CLASS || (termId = this.getTermIdOrNull(node.getId())) == null) continue;
                Term term = this.factory.constructTerm(node, termId);
                termsList.add(term);
            }
            return List.copyOf(termsList);
        }

        private List<Relationship> convertEdgesToRelationships(List<Edge> edges, List<Node> nodes) {
            Map<String, String> propertyIdLabels = nodes.stream().filter(node -> node.getType() == AbstractNode.RDFTYPES.PROPERTY).filter(node -> node.getId() != null && node.getLabel() != null).collect(Collectors.toMap(Node::getId, Node::getLabel));
            ArrayList<Relationship> relationshipsList = new ArrayList<Relationship>();
            if (edges == null || edges.isEmpty()) {
                LOGGER.warn("No edges found in loaded ontology.");
                throw new PhenolRuntimeException("No edges found in loaded ontology.");
            }
            int edgeId = 1;
            for (Edge edge : edges) {
                TermId subjectTermId = this.getTermIdOrNull(edge.getSub());
                TermId objectTermId = this.getTermIdOrNull(edge.getObj());
                if (subjectTermId == null || objectTermId == null) continue;
                RelationshipType relType = RelationshipType.of((String)edge.getPred(), (String)propertyIdLabels.getOrDefault(edge.getPred(), "unknown"));
                Relationship relationship = new Relationship(subjectTermId, objectTermId, edgeId++, relType);
                relationshipsList.add(relationship);
            }
            return List.copyOf(relationshipsList);
        }

        private TermId getTermIdOrNull(String id) {
            Optional curie = this.curieUtil.getCurie(id);
            if (curie.isEmpty()) {
                LOGGER.warn("No matching curie found for id: {}", (Object)id);
                return null;
            }
            String curieStr = (String)curie.get();
            TermId termId = TermId.of((String)curieStr);
            String prefix = termId.getPrefix();
            if (this.wantedTermIdPrefixes.isEmpty() || this.wantedTermIdPrefixes.contains(prefix)) {
                return termId;
            }
            return null;
        }
    }
}

