/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.utils;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.io.utils.CurieUtil;
import org.monarchinitiative.phenol.io.utils.Trie;
import org.monarchinitiative.phenol.ontology.data.TermId;

class CurieUtilDefault
implements CurieUtil {
    private final Trie trie;
    private final Map<String, String> prefixToIri;
    private final Map<String, String> iriToPrefix;

    CurieUtilDefault(Map<String, String> prefixToIri) {
        this.prefixToIri = Objects.requireNonNull(prefixToIri);
        this.iriToPrefix = prefixToIri.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getValue, Map.Entry::getKey));
        this.trie = new Trie(prefixToIri.values());
    }

    @Override
    public boolean hasPrefix(String curiePrefix) {
        return this.prefixToIri.containsKey(curiePrefix);
    }

    @Override
    public Optional<TermId> getCurie(String iri) {
        String prefix = this.trie.search(iri);
        if (prefix.isBlank()) {
            return Optional.empty();
        }
        String curiePrefix = this.iriToPrefix.get(prefix);
        return Optional.of(TermId.of((String)curiePrefix, (String)iri.substring(prefix.length())));
    }

    @Override
    public Optional<String> getExpansion(String curiePrefix) {
        return Optional.ofNullable(this.prefixToIri.get(curiePrefix));
    }
}

