/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.geneontology.obographs.core.model.GraphDocument;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.io.obographs.OboGraphDocumentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OntologyLoadingRoutines {
    private static final Logger logger = LoggerFactory.getLogger(OntologyLoadingRoutines.class);

    private OntologyLoadingRoutines() {
    }

    static GraphDocument loadGraphDocument(File file) {
        GraphDocument graphDocument;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            graphDocument = OntologyLoadingRoutines.loadGraphDocument(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e);
            }
        }
        ((InputStream)is).close();
        return graphDocument;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static GraphDocument loadGraphDocument(InputStream inputStream) {
        try {
            BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
            int readlimit = 16;
            ((InputStream)bufferedStream).mark(readlimit);
            String firstBytes = OntologyLoadingRoutines.readBytes(bufferedStream, readlimit);
            logger.debug("Read first bytes: " + firstBytes);
            if (OntologyLoadingRoutines.isJsonGraphDoc(firstBytes)) {
                logger.debug("Looks like a JSON file...");
                try {
                    ((InputStream)bufferedStream).reset();
                    GraphDocument graphDocument = OboGraphDocumentLoader.loadJson(bufferedStream);
                    return graphDocument;
                }
                catch (Exception e) {
                    throw new PhenolRuntimeException("Error loading JSON", (Throwable)e);
                }
            }
            ((InputStream)bufferedStream).reset();
            catch (Exception e) {
                throw new PhenolRuntimeException("Error loading OBO/OWL", (Throwable)e);
            }
            logger.debug("Looks like a OBO/OWL file...");
            logger.error("OBO/OWL support was removed since 2.0.0");
            throw new PhenolRuntimeException("OBO/OWL support was removed since 2.0.0, use JSON instead");
            finally {
                ((InputStream)bufferedStream).close();
            }
        }
        catch (IOException e) {
            throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e);
        }
    }

    private static String readBytes(InputStream bufferedStream, int readlimit) throws IOException {
        byte[] firstFewBytes = new byte[readlimit];
        if (bufferedStream.read(firstFewBytes) == readlimit) {
            return new String(firstFewBytes);
        }
        return null;
    }

    private static boolean isJsonGraphDoc(String firstBytes) {
        return firstBytes != null && firstBytes.replace("\\W+", "").startsWith("{");
    }
}

