/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.geneontology.obographs.core.model.GraphDocument;
import org.monarchinitiative.phenol.io.OntologyLoaderOptions;
import org.monarchinitiative.phenol.io.obographs.OboGraphDocumentAdaptor;
import org.monarchinitiative.phenol.io.utils.CurieUtil;
import org.monarchinitiative.phenol.io.utils.CurieUtilBuilder;
import org.monarchinitiative.phenol.io.utils.OntologyLoadingRoutines;
import org.monarchinitiative.phenol.ontology.data.ImmutableOntology;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private static final Logger logger = LoggerFactory.getLogger(OntologyLoader.class);

    private OntologyLoader() {
    }

    public static Ontology loadOntology(File file) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(File file, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(File file, CurieUtil curieUtil, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(file);
        return OntologyLoader.loadOntology(graphDocument, curieUtil, termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(InputStream inputStream, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream, CurieUtil curieUtil, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(inputStream, curieUtil, OntologyLoaderOptions.defaultOptions(), termIdPrefixes);
    }

    public static Ontology loadOntology(File file, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(file);
        return OntologyLoader.loadOntology(graphDocument, curieUtil, options, termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(inputStream);
        return OntologyLoader.loadOntology(graphDocument, curieUtil, options, termIdPrefixes);
    }

    public static Ontology loadOntology(GraphDocument graphDocument, CurieUtil curieUtil, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(graphDocument, curieUtil, OntologyLoaderOptions.defaultOptions(), termIdPrefixes);
    }

    public static Ontology loadOntology(GraphDocument graphDocument, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        logger.debug("Finished loading ontology");
        logger.debug("Creating phenol ontology");
        OboGraphDocumentAdaptor graphDocumentAdaptor = OboGraphDocumentAdaptor.builder().curieUtil(curieUtil).wantedTermIdPrefixes(Set.of(termIdPrefixes)).discardNonPropagatingRelationships(options.discardNonPropagatingRelationships()).build(graphDocument);
        ImmutableOntology ontology = ImmutableOntology.builder().metaInfo(graphDocumentAdaptor.getMetaInfo()).terms(graphDocumentAdaptor.getTerms()).relationships(graphDocumentAdaptor.getRelationships()).build();
        logger.debug("Parsed a total of {} terms", (Object)ontology.getTerms().size());
        return ontology;
    }
}

