/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import java.util.Objects;

public class OntologyLoaderOptions {
    private static final OntologyLoaderOptions DEFAULT_OPTIONS = new Builder().build();
    private final boolean discardNonPropagatingRelationships;
    private final boolean discardDuplicatedRelationships;
    private final boolean forceBuild;

    public static OntologyLoaderOptions defaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated(forRemoval=true, since="2.0.3")
    public static OntologyLoaderOptions of(boolean discardNonPropagatingRelationships) {
        return new Builder().discardNonPropagatingRelationships(discardNonPropagatingRelationships).build();
    }

    private OntologyLoaderOptions(Builder builder) {
        this.discardNonPropagatingRelationships = builder.discardNonPropagatingRelationships;
        this.discardDuplicatedRelationships = builder.discardDuplicatedRelationships;
        this.forceBuild = builder.forceBuild;
    }

    public boolean discardNonPropagatingRelationships() {
        return this.discardNonPropagatingRelationships;
    }

    public boolean discardDuplicatedRelationships() {
        return this.discardDuplicatedRelationships;
    }

    public boolean forceBuild() {
        return this.forceBuild;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OntologyLoaderOptions options = (OntologyLoaderOptions)o;
        return this.discardNonPropagatingRelationships == options.discardNonPropagatingRelationships && this.discardDuplicatedRelationships == options.discardDuplicatedRelationships && this.forceBuild == options.forceBuild;
    }

    public int hashCode() {
        return Objects.hash(this.discardNonPropagatingRelationships, this.discardDuplicatedRelationships, this.forceBuild);
    }

    public String toString() {
        return "OntologyLoaderOptions{discardNonPropagatingRelationships=" + this.discardNonPropagatingRelationships + ", discardDuplicatedRelationships=" + this.discardDuplicatedRelationships + ", forceBuild=" + this.forceBuild + "}";
    }

    public static class Builder {
        private boolean discardNonPropagatingRelationships = false;
        private boolean discardDuplicatedRelationships = false;
        private boolean forceBuild = false;

        private Builder() {
        }

        public Builder discardNonPropagatingRelationships(boolean value) {
            this.discardNonPropagatingRelationships = value;
            return this;
        }

        public Builder discardDuplicatedRelationships(boolean value) {
            this.discardDuplicatedRelationships = value;
            return this;
        }

        public Builder forceBuild(boolean value) {
            this.forceBuild = value;
            return this;
        }

        public OntologyLoaderOptions build() {
            return new OntologyLoaderOptions(this);
        }
    }
}

