/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obographs;

import java.util.ArrayList;
import java.util.List;
import org.geneontology.obographs.core.model.Meta;
import org.geneontology.obographs.core.model.Node;
import org.geneontology.obographs.core.model.meta.BasicPropertyValue;
import org.geneontology.obographs.core.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.core.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.core.model.meta.XrefPropertyValue;
import org.monarchinitiative.phenol.ontology.data.Dbxref;
import org.monarchinitiative.phenol.ontology.data.SimpleXref;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermSynonym;
import org.monarchinitiative.phenol.ontology.data.TermSynonymScope;
import org.monarchinitiative.phenol.ontology.data.TermXref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OboGraphTermFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(OboGraphTermFactory.class);

    private OboGraphTermFactory() {
    }

    static Term constructTerm(Node node, TermId termId) {
        List subsets;
        Term.Builder termBuilder = Term.builder((TermId)termId);
        String label = node.getLabel();
        termBuilder.name(label == null ? "" : label);
        Meta meta = node.getMeta();
        if (meta == null) {
            LOGGER.debug("No meta instance exists for node: {} {}", (Object)node.getId(), (Object)node.getLabel());
            return termBuilder.build();
        }
        DefinitionPropertyValue definitionPropertyValue = meta.getDefinition();
        String definition = OboGraphTermFactory.getDefinition(definitionPropertyValue);
        termBuilder.definition(definition);
        List<SimpleXref> simpleXrefs = OboGraphTermFactory.convertToXrefs(definitionPropertyValue);
        termBuilder.databaseXrefs(simpleXrefs);
        List comments = meta.getComments();
        if (comments != null) {
            termBuilder.comment(String.join((CharSequence)", ", comments));
        }
        if ((subsets = meta.getSubsets()) != null) {
            termBuilder.subsets(subsets);
        }
        List<TermSynonym> termSynonyms = OboGraphTermFactory.convertToSynonyms(meta.getSynonyms());
        termBuilder.synonyms(termSynonyms);
        List<Dbxref> xrefs = OboGraphTermFactory.convertToDbXrefs(meta.getXrefs());
        termBuilder.xrefs(xrefs);
        boolean isObsolete = OboGraphTermFactory.isObsolete(meta);
        termBuilder.obsolete(isObsolete);
        List<TermId> altIds = OboGraphTermFactory.convertToAltIds(meta.getBasicPropertyValues());
        termBuilder.altTermIds(altIds);
        return termBuilder.build();
    }

    private static String getDefinition(DefinitionPropertyValue definitionPropertyValue) {
        return definitionPropertyValue == null ? "" : definitionPropertyValue.getVal();
    }

    private static List<SimpleXref> convertToXrefs(DefinitionPropertyValue definitionPropertyValue) {
        if (definitionPropertyValue == null) {
            return List.of();
        }
        List xrefs = definitionPropertyValue.getXrefs();
        if (xrefs == null) {
            return List.of();
        }
        ArrayList<SimpleXref> simpleXrefBuilder = new ArrayList<SimpleXref>();
        for (String xref : xrefs) {
            SimpleXref sxref = new SimpleXref(xref);
            if (!sxref.isValid()) continue;
            simpleXrefBuilder.add(sxref);
        }
        return List.copyOf(simpleXrefBuilder);
    }

    private static List<TermSynonym> convertToSynonyms(List<SynonymPropertyValue> spvs) {
        if (spvs == null) {
            return List.of();
        }
        ArrayList<TermSynonym> termSynonymBuilder = new ArrayList<TermSynonym>();
        for (SynonymPropertyValue spv : spvs) {
            TermSynonymScope scope = null;
            if (spv.isExact()) {
                scope = TermSynonymScope.EXACT;
            } else if (spv.isBroad()) {
                scope = TermSynonymScope.BROAD;
            } else if (spv.isNarrow()) {
                scope = TermSynonymScope.NARROW;
            } else if (spv.isRelated()) {
                scope = TermSynonymScope.RELATED;
            }
            String synonymType = spv.getSynonymType();
            String synonymTypeName = String.join((CharSequence)", ", spv.getTypes());
            List xrefs = spv.getXrefs();
            List<TermXref> termXrefs = OboGraphTermFactory.mapXref(xrefs);
            TermSynonym its = new TermSynonym(spv.getVal(), scope, synonymTypeName, termXrefs, synonymType);
            termSynonymBuilder.add(its);
        }
        return List.copyOf(termSynonymBuilder);
    }

    private static List<TermXref> mapXref(List<String> xrefs) {
        ArrayList<TermXref> termXrefBuilder = new ArrayList<TermXref>();
        for (String xref : xrefs) {
            try {
                TermId xrefTermId = TermId.of((String)xref);
                TermXref trf = new TermXref(xrefTermId, "");
                termXrefBuilder.add(trf);
            }
            catch (Exception exception) {}
        }
        return List.copyOf(termXrefBuilder);
    }

    private static List<Dbxref> convertToDbXrefs(List<XrefPropertyValue> xrefPropertyValues) {
        if (xrefPropertyValues == null || xrefPropertyValues.isEmpty()) {
            return List.of();
        }
        ArrayList<Dbxref> dbxrefs = new ArrayList<Dbxref>();
        for (XrefPropertyValue xrefPropertyValue : xrefPropertyValues) {
            String val = xrefPropertyValue.getVal();
            if (val == null) continue;
            dbxrefs.add(new Dbxref(val, null, null));
        }
        return List.copyOf(dbxrefs);
    }

    private static boolean isObsolete(Meta meta) {
        try {
            return meta.getDeprecated();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return false;
        }
    }

    private static List<TermId> convertToAltIds(List<BasicPropertyValue> basicPropertyValues) {
        if (basicPropertyValues == null || basicPropertyValues.isEmpty()) {
            return List.of();
        }
        ArrayList<TermId> altIdsBuilder = new ArrayList<TermId>();
        for (BasicPropertyValue bpv : basicPropertyValues) {
            if (!"http://www.geneontology.org/formats/oboInOwl#hasAlternativeId".equals(bpv.getPred())) continue;
            String altId = bpv.getVal();
            altIdsBuilder.add(TermId.of((String)altId));
        }
        return List.copyOf(altIdsBuilder);
    }
}

