/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obographs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.geneontology.obographs.core.model.GraphDocument;

public class OboGraphDocumentLoader {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private OboGraphDocumentLoader() {
    }

    public static GraphDocument loadJson(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            GraphDocument graphDocument = OboGraphDocumentLoader.loadJson(is);
            return graphDocument;
        }
    }

    public static GraphDocument loadJson(InputStream inputStream) throws IOException {
        return (GraphDocument)OBJECT_MAPPER.readValue(inputStream, GraphDocument.class);
    }
}

