/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.geneontology.obographs.core.model.GraphDocument;
import org.monarchinitiative.phenol.io.OntologyLoaderOptions;
import org.monarchinitiative.phenol.io.obographs.OboGraphDocumentAdaptor;
import org.monarchinitiative.phenol.io.utils.CurieUtil;
import org.monarchinitiative.phenol.io.utils.CurieUtilBuilder;
import org.monarchinitiative.phenol.io.utils.OntologyLoadingRoutines;
import org.monarchinitiative.phenol.ontology.data.MinimalOntology;
import org.monarchinitiative.phenol.ontology.data.RelationshipType;
import org.monarchinitiative.phenol.ontology.data.impl.SimpleMinimalOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimalOntologyLoader {
    private static final Logger logger = LoggerFactory.getLogger(MinimalOntologyLoader.class);

    private MinimalOntologyLoader() {
    }

    public static MinimalOntology loadOntology(File file) {
        return MinimalOntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static MinimalOntology loadOntology(File file, String ... termIdPrefixes) {
        return MinimalOntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static MinimalOntology loadOntology(File file, CurieUtil curieUtil, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(file);
        return MinimalOntologyLoader.loadOntology(graphDocument, curieUtil, termIdPrefixes);
    }

    public static MinimalOntology loadOntology(InputStream inputStream) {
        return MinimalOntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static MinimalOntology loadOntology(InputStream inputStream, String ... termIdPrefixes) {
        return MinimalOntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static MinimalOntology loadOntology(InputStream inputStream, CurieUtil curieUtil, String ... termIdPrefixes) {
        return MinimalOntologyLoader.loadOntology(inputStream, curieUtil, OntologyLoaderOptions.defaultOptions(), termIdPrefixes);
    }

    public static MinimalOntology loadOntology(GraphDocument graphDocument, CurieUtil curieUtil, String ... termIdPrefixes) {
        return MinimalOntologyLoader.loadOntology(graphDocument, curieUtil, OntologyLoaderOptions.defaultOptions(), termIdPrefixes);
    }

    public static MinimalOntology loadOntology(File file, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(file);
        return MinimalOntologyLoader.loadOntology(graphDocument, curieUtil, options, termIdPrefixes);
    }

    public static MinimalOntology loadOntology(InputStream inputStream, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoadingRoutines.loadGraphDocument(inputStream);
        return MinimalOntologyLoader.loadOntology(graphDocument, curieUtil, options, termIdPrefixes);
    }

    public static MinimalOntology loadOntology(GraphDocument graphDocument, CurieUtil curieUtil, OntologyLoaderOptions options, String ... termIdPrefixes) {
        logger.debug("Finished loading ontology");
        logger.debug("Creating minimal ontology");
        OboGraphDocumentAdaptor graphDocumentAdaptor = OboGraphDocumentAdaptor.builder().curieUtil(curieUtil).wantedTermIdPrefixes(Set.of(termIdPrefixes)).discardNonPropagatingRelationships(options.discardNonPropagatingRelationships()).discardDuplicatedRelationships(options.discardDuplicatedRelationships()).build(graphDocument);
        SimpleMinimalOntology ontology = SimpleMinimalOntology.builder().forceBuild(options.forceBuild()).hierarchyRelationshipType(RelationshipType.IS_A).graphImplementation(SimpleMinimalOntology.Builder.GraphImplementation.MONO).metaInfo(graphDocumentAdaptor.getMetaInfo()).terms(graphDocumentAdaptor.getTerms()).relationships(graphDocumentAdaptor.getRelationships()).build();
        logger.debug("Parsed a total of {} terms", (Object)ontology.getTerms().size());
        return ontology;
    }
}

